/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso.ui;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.SessionIndex;
import org.opensaml.xml.XMLObject;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.SAML2SSOUIAuthenticatorException;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.Util;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.internal.SAML2SSOAuthFEDataHolder;
import org.wso2.carbon.ui.CarbonSSOSessionManager;
import org.wso2.carbon.ui.CarbonUIUtil;

public class SSOAssertionConsumerService
extends HttpServlet {
    public static final Log log = LogFactory.getLog(SSOAssertionConsumerService.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String samlRespString = req.getParameter("SAMLResponse");
        String relayState = req.getParameter("RelayState");
        if (log.isDebugEnabled()) {
            log.debug((Object)("SAML Response Received. : " + samlRespString));
        }
        if (req.getParameter("SAMLRequest") != null) {
            this.handleSingleLogoutRequest(req, resp);
            return;
        }
        if (samlRespString == null) {
            log.error((Object)"SAML Response is not present in the request.");
            this.handleMalformedResponses(req, resp, "response.not.present");
            return;
        }
        try {
            XMLObject samlObject = Util.unmarshall(samlRespString);
            if (samlObject instanceof LogoutResponse) {
                resp.sendRedirect(this.getAdminConsoleURL(req) + "admin/logout_action.jsp?logoutcomplete=true");
            } else if (samlObject instanceof Response) {
                this.handleSAMLResponses(req, resp, samlObject);
            }
        }
        catch (SAML2SSOUIAuthenticatorException e) {
            log.error((Object)"Error when processing the SAML Assertion in the request.", (Throwable)e);
            this.handleMalformedResponses(req, resp, "response.malformed");
        }
    }

    private void handleSAMLResponses(HttpServletRequest req, HttpServletResponse resp, XMLObject samlObject) throws ServletException, IOException, SAML2SSOUIAuthenticatorException {
        Response samlResponse = (Response)samlObject;
        List assertions = samlResponse.getAssertions();
        Assertion assertion = null;
        if (assertions != null && assertions.size() > 0) {
            assertion = (Assertion)assertions.get(0);
        }
        if (assertion == null) {
            log.error((Object)"SAMLResponse does not contain Assertions.");
            throw new SAML2SSOUIAuthenticatorException("SAMLResponse does not contain Assertions.");
        }
        String username = null;
        if (assertion.getSubject() != null && assertion.getSubject().getNameID() != null) {
            username = assertion.getSubject().getNameID().getValue();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("A username is extracted from the response. : " + username));
        }
        if (username == null) {
            log.error((Object)"SAMLResponse does not contain the name of the subject");
            throw new SAML2SSOUIAuthenticatorException("SAMLResponse does not contain the name of the subject");
        }
        req.setAttribute("SAML2ResponseToken", (Object)samlResponse);
        String url = req.getRequestURI();
        url = url.replace("acs", "carbon/admin/login_action.jsp?username=" + URLEncoder.encode(username));
        RequestDispatcher reqDispatcher = req.getRequestDispatcher(url);
        reqDispatcher.forward((ServletRequest)req, (ServletResponse)resp);
    }

    private void handleMalformedResponses(HttpServletRequest req, HttpServletResponse resp, String errorMsg) throws IOException {
        HttpSession session = req.getSession();
        session.setAttribute("ErrorMessage", (Object)errorMsg);
        resp.sendRedirect(this.getAdminConsoleURL(req) + "sso-acs/notifications.jsp");
    }

    private void handleSingleLogoutRequest(HttpServletRequest req, HttpServletResponse resp) {
        LogoutRequest logoutRequest;
        List sessionIndexList;
        String logoutReqStr = this.decodeHTMLCharacters(req.getParameter("SAMLRequest"));
        CarbonSSOSessionManager ssoSessionManager = null;
        XMLObject samlObject = null;
        try {
            ssoSessionManager = SAML2SSOAuthFEDataHolder.getInstance().getCarbonSSOSessionManager();
            samlObject = Util.unmarshall(logoutReqStr);
        }
        catch (SAML2SSOUIAuthenticatorException e) {
            log.error((Object)"Error handling the single logout request", (Throwable)e);
        }
        if (samlObject instanceof LogoutRequest && (sessionIndexList = (logoutRequest = (LogoutRequest)samlObject).getSessionIndexes()).size() > 0) {
            ssoSessionManager.makeSessionInvalid(((SessionIndex)sessionIndexList.get(0)).getSessionIndex());
        }
    }

    private String getAdminConsoleURL(HttpServletRequest request) {
        String url = CarbonUIUtil.getAdminConsoleURL((HttpServletRequest)request);
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        if (url.indexOf("/acs") != -1) {
            url = url.replace("/acs", "");
        }
        return url;
    }

    private String decodeHTMLCharacters(String encodedStr) {
        return encodedStr.replaceAll("&amp;", "&").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&apos;", "'");
    }
}

