/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tenant.dispatcher.internal;

import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.PhaseRule;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.phaseresolver.PhaseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.multitenancy.MultitenantDispatcher;
import org.wso2.carbon.core.multitenancy.MultitenantMessageReceiver;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.multitenancy.MultitenantConstants;

public class TenantDispatcherServiceComponent {
    private Log log = LogFactory.getLog(TenantDispatcherServiceComponent.class);
    private ConfigurationContext configCtx;

    protected void activate(ComponentContext ctxt) {
        try {
            this.deployMultitenantService(this.configCtx.getAxisConfiguration());
            this.addDispatchers(this.configCtx.getAxisConfiguration());
        }
        catch (Throwable e) {
            this.log.error((Object)"Failed to activate the TenantDispatcherServiceComponent", e);
        }
    }

    private void deployMultitenantService(AxisConfiguration axisCfg) throws AxisFault {
        AxisService service = new AxisService("__MultitenantDispatcherService");
        InOutAxisOperation operation = new InOutAxisOperation(MultitenantConstants.MULTITENANT_DISPATCHER_OPERATION);
        operation.setMessageReceiver((MessageReceiver)new MultitenantMessageReceiver());
        service.addOperation((AxisOperation)operation);
        AxisServiceGroup multitenantSvcGroup = new AxisServiceGroup(axisCfg);
        multitenantSvcGroup.setServiceGroupName("__MultitenantDispatcherService");
        multitenantSvcGroup.addParameter("hiddenService", (Object)"true");
        multitenantSvcGroup.addService(service);
        axisCfg.addServiceGroup(multitenantSvcGroup);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Deployed __MultitenantDispatcherService");
        }
    }

    private void addDispatchers(AxisConfiguration mainAxisConfig) throws AxisFault {
        HandlerDescription handlerDescription = new HandlerDescription("MultitenantDispatcher");
        PhaseRule rule = new PhaseRule("Dispatch");
        rule.setAfter("HTTPLocationBasedDispatcher");
        rule.setBefore("SynapseDispatcher");
        handlerDescription.setRules(rule);
        MultitenantDispatcher multitenantDispatcher = new MultitenantDispatcher();
        multitenantDispatcher.initDispatcher();
        handlerDescription.setHandler((Handler)multitenantDispatcher);
        List inflowPhases = mainAxisConfig.getInFlowPhases();
        for (Phase inPhase : inflowPhases) {
            if (!"Dispatch".equals(inPhase.getPhaseName())) continue;
            boolean handlerFound = false;
            for (Handler handler : inPhase.getHandlers()) {
                if (handler.getHandlerDesc().getName() == null || !handler.getHandlerDesc().getName().equals("MultitenantDispatcher")) continue;
                handlerFound = true;
            }
            if (handlerFound) continue;
            try {
                inPhase.addHandler(handlerDescription);
            }
            catch (PhaseException e) {
                String msg = "Couldn't start Carbon, Cannot add the required Carbon handlers";
                this.log.fatal((Object)msg, (Throwable)e);
                throw new AxisFault(msg);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.info((Object)"Added multitenant dispatchers");
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Deactivated TenantDispatcherServiceComponent");
        }
    }

    protected void setConfigurationContext(ConfigurationContextService configCtx) {
        this.configCtx = configCtx.getServerConfigContext();
    }

    protected void unsetConfigurationContext(ConfigurationContextService configCtx) {
        this.configCtx = null;
    }
}

