/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.authenticator.saml2.sso.SAML2SSOAuthenticatorException;
import org.wso2.carbon.identity.authenticator.saml2.sso.internal.SAML2SSOAuthBEDataHolder;
import org.wso2.carbon.identity.authenticator.saml2.sso.util.X509CredentialImpl;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.xml.sax.SAXException;

public class Util {
    private static boolean bootStrapped = false;
    private static Log log = LogFactory.getLog(Util.class);

    public static XMLObject unmarshall(String authReqStr) throws SAML2SSOAuthenticatorException {
        try {
            Util.doBootstrap();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new ByteArrayInputStream(authReqStr.trim().getBytes()));
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            XMLObject response = unmarshaller.unmarshall(element);
            NodeList list = response.getDOM().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "Response");
            if (list.getLength() > 0) {
                log.error((Object)"Invalid schema for the SAML2 reponse");
                throw new SAML2SSOAuthenticatorException("Error occured while processing saml2 response");
            }
            return response;
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage());
            throw new SAML2SSOAuthenticatorException("Error occured while processing saml2 response");
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage());
            throw new SAML2SSOAuthenticatorException("Error occured while processing saml2 response");
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            throw new SAML2SSOAuthenticatorException("Error occured while processing saml2 response");
        }
        catch (UnmarshallingException e) {
            log.error((Object)e.getMessage());
            throw new SAML2SSOAuthenticatorException("Error occured while processing saml2 response");
        }
    }

    public static void doBootstrap() {
        if (!bootStrapped) {
            try {
                DefaultBootstrap.bootstrap();
                bootStrapped = true;
            }
            catch (ConfigurationException e) {
                log.error((Object)"Error in bootstrapping the OpenSAML2 library", (Throwable)e);
            }
        }
    }

    public static X509CredentialImpl getX509CredentialImplForTenant(String domainName) throws SAML2SSOAuthenticatorException {
        int tenantID = -1234;
        RegistryService registryService = SAML2SSOAuthBEDataHolder.getInstance().getRegistryService();
        RealmService realmService = SAML2SSOAuthBEDataHolder.getInstance().getRealmService();
        if (!domainName.equals("carbon.super")) {
            try {
                tenantID = realmService.getTenantManager().getTenantId(domainName);
            }
            catch (UserStoreException e) {
                String errorMsg = "Error getting the TenantID for the domain name";
                log.error((Object)errorMsg, (Throwable)e);
                throw new SAML2SSOAuthenticatorException(errorMsg, e);
            }
        }
        KeyStoreManager keyStoreManager = null;
        keyStoreManager = KeyStoreManager.getInstance((int)tenantID);
        X509CredentialImpl credentialImpl = null;
        try {
            if (tenantID != -1234) {
                KeyStore keystore = keyStoreManager.getKeyStore(Util.generateKSNameFromDomainName(domainName));
                X509Certificate cert = (X509Certificate)keystore.getCertificate(domainName);
                credentialImpl = new X509CredentialImpl(cert);
            } else {
                String alias = SAML2SSOAuthBEDataHolder.getInstance().getIdPCertAlias();
                X509Certificate cert = null;
                if (alias != null) {
                    cert = (X509Certificate)keyStoreManager.getPrimaryKeyStore().getCertificate(alias);
                    if (cert == null) {
                        String errorMsg = "Cannot find a certificate with the alias " + alias + " in the default key store. Please check the 'KeyAlias' property in" + " the SSO configuration of the authenticators.xml";
                        log.error((Object)errorMsg);
                        throw new SAML2SSOAuthenticatorException(errorMsg);
                    }
                } else {
                    cert = keyStoreManager.getDefaultPrimaryCertificate();
                }
                credentialImpl = new X509CredentialImpl(cert);
            }
        }
        catch (Exception e) {
            String errorMsg = "Error instantiating an X509CredentialImpl object for the public cert.";
            log.error((Object)errorMsg, (Throwable)e);
            throw new SAML2SSOAuthenticatorException(errorMsg, e);
        }
        return credentialImpl;
    }

    private static String generateKSNameFromDomainName(String tenantDomain) {
        String ksName = tenantDomain.trim().replace(".", "-");
        return ksName + ".jks";
    }
}

