/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.agent.listeners;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.throttling.agent.ThrottlingAgent;
import org.wso2.carbon.throttling.agent.cache.TenantThrottlingInfo;
import org.wso2.carbon.throttling.agent.cache.ThrottlingActionInfo;
import org.wso2.carbon.tomcat.ext.valves.CarbonTomcatValve;
import org.wso2.carbon.user.api.UserStoreException;

public class WebAppRequestListener
implements CarbonTomcatValve {
    private static final Log log = LogFactory.getLog(WebAppRequestListener.class);
    private static final Pattern servicesURLPattern = Pattern.compile("\\/services\\/t\\/(.*?)\\/");
    private static final Pattern webAppsURLPattern = Pattern.compile("\\/t\\/(.*?)\\/webapps\\/");
    private static final String CONTEXT_SERVICES = "services";
    private static final String CONTEXT_WEBAPPS = "webapps";
    private ThrottlingAgent throttlingAgent;

    public WebAppRequestListener(ThrottlingAgent throttlingAgent) {
        this.throttlingAgent = throttlingAgent;
    }

    public void invoke(HttpServletRequest request, HttpServletResponse response) {
        block12: {
            String requestURI = request.getRequestURI();
            String tenantDomainName = this.getTenantName(requestURI);
            String urlContext = this.getContext(requestURI);
            try {
                int tenantId = this.throttlingAgent.getRealmService().getTenantManager().getTenantId(tenantDomainName);
                if (tenantId <= 0) break block12;
                if (!this.throttlingAgent.getRealmService().getTenantManager().getTenant(tenantId).isActive()) {
                    String msg = "You are sending request to inactivated tenant. for Domain: " + tenantDomainName;
                    log.error((Object)msg);
                    try {
                        response.sendError(403, msg);
                    }
                    catch (IOException e) {
                        String message = "Error in Sending throttling rule violation by inactive tenant tenant Domain: " + tenantDomainName;
                        log.error((Object)message, (Throwable)e);
                    }
                    break block12;
                }
                if (urlContext == null) break block12;
                if (CONTEXT_WEBAPPS.equals(urlContext)) {
                    try {
                        String[] actions;
                        ThrottlingActionInfo actionInfo;
                        TenantThrottlingInfo throttlingInfo = this.throttlingAgent.getThrottlingInfoCache().getTenantThrottlingInfo(tenantId);
                        if (throttlingInfo != null && (actionInfo = throttlingInfo.getThrottlingActionInfo(actions = new String[]{"webapp_in_bandwith_action", "webapp_out_bandwith_action"})) != null && actionInfo.isBlocked()) {
                            String blockedMsg = actionInfo.getMessage();
                            String msg = "The throttling action is blocked. message: " + blockedMsg;
                            log.error((Object)msg);
                            response.sendError(509, msg);
                        }
                        break block12;
                    }
                    catch (Exception ex) {
                        String msg = "Error in Sending throttling rule violation. for tenant Domain: " + tenantDomainName;
                        log.error((Object)msg, (Throwable)ex);
                        return;
                    }
                }
                if (!CONTEXT_SERVICES.equals(urlContext)) break block12;
                try {
                    String[] actions;
                    ThrottlingActionInfo actionInfo;
                    TenantThrottlingInfo throttlingInfo = this.throttlingAgent.getThrottlingInfoCache().getTenantThrottlingInfo(tenantId);
                    if (throttlingInfo != null && (actionInfo = throttlingInfo.getThrottlingActionInfo(actions = new String[]{"service_in_bandwith_action", "service_out_bandwith_action"})) != null && actionInfo.isBlocked()) {
                        String blockedMsg = actionInfo.getMessage();
                        String msg = "The throttling action is blocked. message: " + blockedMsg;
                        log.error((Object)msg);
                        response.sendError(509, msg);
                    }
                }
                catch (Exception ex) {
                    String msg = "Error in Sending throttling rule violation. for tenant Domain: " + tenantDomainName;
                    log.error((Object)msg, (Throwable)ex);
                }
            }
            catch (UserStoreException e) {
                String msg = "Error in getting tenant id for evaluate throttling rule. for tenant Domain: " + tenantDomainName;
                log.error((Object)msg, (Throwable)e);
            }
        }
    }

    public String getTenantName(String requestUrl) {
        Matcher matcher = servicesURLPattern.matcher(requestUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        matcher = webAppsURLPattern.matcher(requestUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "carbon.super";
    }

    public String getContext(String requestUrl) {
        Matcher matcher = servicesURLPattern.matcher(requestUrl);
        if (matcher.find()) {
            return CONTEXT_SERVICES;
        }
        matcher = webAppsURLPattern.matcher(requestUrl);
        if (matcher.find()) {
            return CONTEXT_WEBAPPS;
        }
        return null;
    }
}

