/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tenant.mgt.core.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.tenant.mgt.core.internal.TenantMgtCoreServiceComponent;
import org.wso2.carbon.utils.AuthenticationObserver;

public class TenantCoreUtil {
    private static final Log log = LogFactory.getLog(TenantCoreUtil.class);

    public static void initializeRegistry(int tenantId) {
        BundleContext bundleContext = TenantMgtCoreServiceComponent.getBundleContext();
        if (bundleContext != null) {
            ServiceTracker tracker = new ServiceTracker(bundleContext, AuthenticationObserver.class.getName(), null);
            tracker.open();
            Object[] services = tracker.getServices();
            if (services != null) {
                for (Object service : services) {
                    ((AuthenticationObserver)service).startedAuthentication(tenantId);
                }
            }
            tracker.close();
        }
    }

    public static void setOriginatedService(int tenantId, String originatedService) throws Exception {
        if (originatedService != null) {
            String originatedServicePath = "/repository/components/org.wso2.carbon.originated-service/originatedService/" + tenantId;
            try {
                Resource origServiceRes = TenantMgtCoreServiceComponent.getGovernanceSystemRegistry(-1234).newResource();
                origServiceRes.setContent((Object)originatedService);
                TenantMgtCoreServiceComponent.getGovernanceSystemRegistry(-1234).put(originatedServicePath, origServiceRes);
            }
            catch (RegistryException e) {
                String msg = "Error in putting the originated service resource to the governance registry";
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, (Throwable)e);
            }
        }
    }
}

