/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.installer.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;

public class SampleConfig {
    private static final String CONFIG_NS = "http://wso2.com/stratos/samples";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String FILE_NAME_ELEMENT_NAME = "fileName";
    private static final String CLOUD_SERVICES_ELEMENT_NAME = "cloudServices";
    private static final String CLOUD_SERVICE_ELEMENT_NAME = "cloudService";
    private String name;
    private String fileName;
    private List<String> cloudServices = new ArrayList<String>();

    public SampleConfig(OMElement configEle) {
        this.serialize(configEle);
    }

    private void serialize(OMElement configEle) {
        Iterator sampleChildIt = configEle.getChildElements();
        this.name = configEle.getAttributeValue(new QName(null, NAME_ATTRIBUTE_NAME));
        while (sampleChildIt.hasNext()) {
            Object sampleChildObj = sampleChildIt.next();
            if (!(sampleChildObj instanceof OMElement)) continue;
            OMElement sampleChildEle = (OMElement)sampleChildObj;
            if (new QName(CONFIG_NS, FILE_NAME_ELEMENT_NAME, "").equals(sampleChildEle.getQName())) {
                this.fileName = sampleChildEle.getText();
                continue;
            }
            if (!new QName(CONFIG_NS, CLOUD_SERVICES_ELEMENT_NAME, "").equals(sampleChildEle.getQName())) continue;
            Iterator cloudServicesChildIt = sampleChildEle.getChildElements();
            while (cloudServicesChildIt.hasNext()) {
                OMElement cloudServiceChildEle;
                Object cloudServiceChildObj = cloudServicesChildIt.next();
                if (!(cloudServiceChildObj instanceof OMElement) || !new QName(CONFIG_NS, CLOUD_SERVICE_ELEMENT_NAME, "").equals((cloudServiceChildEle = (OMElement)cloudServiceChildObj).getQName())) continue;
                this.cloudServices.add(cloudServiceChildEle.getAttributeValue(new QName(null, NAME_ATTRIBUTE_NAME)));
            }
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getCloudServices() {
        return this.cloudServices.toArray(new String[this.cloudServices.size()]);
    }

    public String getName() {
        return this.name;
    }
}

