/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tenant.mgt.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.multitenancy.persistence.TenantPersistor;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.stratos.common.TenantBillingService;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.stratos.common.util.StratosConfiguration;
import org.wso2.carbon.tenant.mgt.internal.util.TenantMgtRampartUtil;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.ConfigurationContextService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TenantMgtServiceComponent {
    private static Log log = LogFactory.getLog(TenantMgtServiceComponent.class);
    private static final String GAPP_TENANT_REG_SERVICE_NAME = "GAppTenantRegistrationService";
    private static RealmService realmService;
    private static RegistryService registryService;
    private static ConfigurationContextService configurationContextService;
    private static List<TenantMgtListener> tenantMgtListeners;
    private static TenantPersistor tenantPersistor;
    private static TenantBillingService billingService;

    protected void activate(ComponentContext context) {
        try {
            if (CommonUtil.getStratosConfig() == null) {
                StratosConfiguration stratosConfig = CommonUtil.loadStratosConfiguration();
                CommonUtil.setStratosConfig((StratosConfiguration)stratosConfig);
            }
            if (CommonUtil.getEula() == null) {
                String eula = CommonUtil.loadTermsOfUsage();
                CommonUtil.setEula((String)eula);
            }
            this.populateRampartConfig(configurationContextService.getServerConfigContext().getAxisConfiguration());
            log.debug((Object)"******* Tenant Config bundle is activated ******* ");
        }
        catch (Exception e) {
            log.error((Object)"******* Tenant Config bundle failed activating ****", (Throwable)e);
        }
    }

    protected void setTenantMgtListenerService(TenantMgtListener tenantMgtListener) {
        TenantMgtServiceComponent.addTenantMgtListener(tenantMgtListener);
    }

    protected void unsetTenantMgtListenerService(TenantMgtListener tenantMgtListener) {
        TenantMgtServiceComponent.removeTenantMgtListener(tenantMgtListener);
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Governance Tenant Config bundle is deactivated ******* ");
    }

    protected void setRegistryService(RegistryService registryService) {
        TenantMgtServiceComponent.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        TenantMgtServiceComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        this.setRealmService(null);
    }

    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"Receiving ConfigurationContext Service");
        TenantMgtServiceComponent.configurationContextService = configurationContextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"Unsetting ConfigurationContext Service");
        this.setConfigurationContextService(null);
    }

    public static void addTenantMgtListener(TenantMgtListener tenantMgtListener) {
        tenantMgtListeners.add(tenantMgtListener);
        TenantMgtServiceComponent.sortTenantMgtListeners();
    }

    public static void removeTenantMgtListener(TenantMgtListener tenantMgtListener) {
        tenantMgtListeners.remove(tenantMgtListener);
        TenantMgtServiceComponent.sortTenantMgtListeners();
    }

    public static void sortTenantMgtListeners() {
        Collections.sort(tenantMgtListeners, new Comparator<TenantMgtListener>(){

            @Override
            public int compare(TenantMgtListener o1, TenantMgtListener o2) {
                return o1.getListenerOrder() - o2.getListenerOrder();
            }
        });
    }

    public static List<TenantMgtListener> getTenantMgtListeners() {
        return tenantMgtListeners;
    }

    public static ConfigurationContextService getConfigurationContextService() {
        return configurationContextService;
    }

    public static ConfigurationContext getConfigurationContext() {
        if (configurationContextService.getServerConfigContext() == null) {
            return null;
        }
        return configurationContextService.getServerConfigContext();
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static TenantManager getTenantManager() {
        return realmService.getTenantManager();
    }

    public static RealmConfiguration getBootstrapRealmConfiguration() {
        return realmService.getBootstrapRealmConfiguration();
    }

    public static UserRegistry getGovernanceSystemRegistry(int tenantId) throws RegistryException {
        return registryService.getGovernanceSystemRegistry(tenantId);
    }

    public static UserRegistry getConfigSystemRegistry(int tenantId) throws RegistryException {
        return registryService.getConfigSystemRegistry(tenantId);
    }

    public static TenantPersistor getTenantPersistor() {
        return tenantPersistor;
    }

    protected void setTenantPersistor(TenantPersistor defaultTenantPersistor) {
        tenantPersistor = defaultTenantPersistor;
    }

    public void unsetTenantPersistor(TenantPersistor defaultTenantPersistor) {
        tenantPersistor = null;
    }

    private void populateRampartConfig(AxisConfiguration config) throws Exception {
        AxisService service = config.getService(GAPP_TENANT_REG_SERVICE_NAME);
        if (service == null) {
            String msg = "GAppTenantRegistrationService is not available in the Configuration Context";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        Policy rampartConfig = TenantMgtRampartUtil.getDefaultRampartConfig();
        service.getPolicySubject().attachPolicy(rampartConfig);
    }

    protected void setTenantBillingService(TenantBillingService tenantBillingService) {
        billingService = tenantBillingService;
    }

    protected void unsetTenantBillingService(TenantBillingService tenantBilling) {
        this.setTenantBillingService(null);
    }

    public static TenantBillingService getBillingService() {
        return billingService;
    }

    static {
        tenantMgtListeners = new ArrayList<TenantMgtListener>();
        tenantPersistor = null;
        billingService = null;
    }
}

