/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.io;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshallerFactory {
    private final Logger log = LoggerFactory.getLogger(MarshallerFactory.class);
    private Map<QName, Marshaller> marshallers = new ConcurrentHashMap<QName, Marshaller>();

    public Marshaller getMarshaller(QName key) {
        if (key == null) {
            return null;
        }
        return this.marshallers.get(key);
    }

    public Marshaller getMarshaller(XMLObject xmlObject) {
        Marshaller marshaller = this.getMarshaller(xmlObject.getSchemaType());
        if (marshaller == null) {
            marshaller = this.getMarshaller(xmlObject.getElementQName());
        }
        return marshaller;
    }

    public Map<QName, Marshaller> getMarshallers() {
        return Collections.unmodifiableMap(this.marshallers);
    }

    public void registerMarshaller(QName key, Marshaller marshaller) {
        this.log.debug("Registering marshaller, {}, for object type {}", (Object)marshaller.getClass().getName(), (Object)key);
        if (key == null) {
            throw new IllegalArgumentException("Marshaller key may not be null");
        }
        this.marshallers.put(key, marshaller);
    }

    public Marshaller deregisterMarshaller(QName key) {
        this.log.debug("Deregistering marshaller for object type {}", (Object)key);
        if (key != null) {
            return this.marshallers.remove(key);
        }
        return null;
    }
}

