/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.artifact;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.BasicEndpointSelector;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.artifact.SAML2ArtifactBuilder;
import org.opensaml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.IndexedEndpoint;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML2ArtifactType0004Builder
implements SAML2ArtifactBuilder<SAML2ArtifactType0004> {
    private final Logger log = LoggerFactory.getLogger(SAML2ArtifactType0004Builder.class);

    @Override
    public SAML2ArtifactType0004 buildArtifact(byte[] artifact) {
        return SAML2ArtifactType0004.parseArtifact(artifact);
    }

    @Override
    public SAML2ArtifactType0004 buildArtifact(SAMLMessageContext<SAMLObject, SAMLObject, NameID> requestContext) {
        try {
            IndexedEndpoint acsEndpoint = (IndexedEndpoint)this.getAcsEndpoint(requestContext);
            if (acsEndpoint == null) {
                return null;
            }
            byte[] endpointIndex = DatatypeHelper.intToByteArray(acsEndpoint.getIndex());
            byte[] trimmedIndex = new byte[]{endpointIndex[2], endpointIndex[3]};
            MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
            byte[] source = sha1Digester.digest(requestContext.getLocalEntityId().getBytes());
            SecureRandom handleGenerator = SecureRandom.getInstance("SHA1PRNG");
            byte[] assertionHandle = new byte[20];
            handleGenerator.nextBytes(assertionHandle);
            return new SAML2ArtifactType0004(trimmedIndex, source, assertionHandle);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("JVM does not support required cryptography algorithms: SHA-1/SHA1PRNG.", (Throwable)e);
            throw new InternalError("JVM does not support required cryptography algorithms: SHA-1/SHA1PRNG.");
        }
    }

    protected Endpoint getAcsEndpoint(SAMLMessageContext<SAMLObject, SAMLObject, NameID> requestContext) {
        BasicEndpointSelector selector = new BasicEndpointSelector();
        selector.setEndpointType(ArtifactResolutionService.DEFAULT_ELEMENT_NAME);
        selector.getSupportedIssuerBindings().add("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        selector.setMetadataProvider(requestContext.getMetadataProvider());
        selector.setEntityMetadata(requestContext.getLocalEntityMetadata());
        selector.setEntityRoleMetadata(requestContext.getLocalEntityRoleMetadata());
        Endpoint acsEndpoint = selector.selectEndpoint();
        if (acsEndpoint == null) {
            this.log.error("No artifact resolution service endpoint defined for the entity " + requestContext.getOutboundMessageIssuer());
            return null;
        }
        return acsEndpoint;
    }
}

