/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.redirector.servlet.ui.filters;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.redirector.servlet.ui.clients.RedirectorServletServiceClient;

public class AllPagesFilter
implements Filter {
    private static final Log log = LogFactory.getLog(AllPagesFilter.class);
    private static Map<String, Boolean> tenantExistMap = new HashMap<String, Boolean>();
    ServletContext context;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String requestedURI = request.getRequestURI();
        StringTokenizer tokenizer = new StringTokenizer(requestedURI.substring(1), "/");
        String[] firstUriTokens = new String[2];
        int i = 0;
        while (tokenizer.hasMoreElements()) {
            firstUriTokens[i] = tokenizer.nextToken();
            if (++i <= 1) continue;
        }
        if (i > 1 && firstUriTokens[0].equals("t")) {
            String errorPage;
            String contextPath;
            if (requestedURI.startsWith("//")) {
                requestedURI = requestedURI.replaceFirst("//", "/");
            }
            String path = requestedURI.substring(firstUriTokens[0].length() + firstUriTokens[1].length() + 2);
            String tenantDomain = firstUriTokens[1];
            boolean tenantExists = true;
            boolean tenantActive = true;
            if (tenantExistMap.get(tenantDomain) == null) {
                RedirectorServletServiceClient client;
                try {
                    client = new RedirectorServletServiceClient(this.context, request.getSession());
                }
                catch (Exception e) {
                    String msg = "Error in constructing RedirectorServletServiceClient.";
                    log.error((Object)msg, (Throwable)e);
                    throw new ServletException(msg, (Throwable)e);
                }
                try {
                    String status = client.validateTenant(tenantDomain);
                    boolean bl = tenantExists = !"invalidTenant".equals(status);
                    if (tenantExists && "activeTenant".equals(status)) {
                        tenantActive = true;
                    }
                }
                catch (Exception e) {
                    String msg = "Error in checking the existing of the tenant domain: " + tenantDomain + ".";
                    log.error((Object)msg, (Throwable)e);
                    throw new ServletException(msg, (Throwable)e);
                }
            }
            if (tenantExists) {
                if (!tenantActive) {
                    contextPath = request.getContextPath();
                    if (contextPath == null || contextPath.equals("/")) {
                        contextPath = "";
                    }
                    errorPage = contextPath + "/carbon/admin/error.jsp?The Requested tenant domain: " + tenantDomain + " is inactive.";
                    RequestDispatcher requestDispatcher = request.getRequestDispatcher(errorPage);
                    requestDispatcher.forward((ServletRequest)request, servletResponse);
                    return;
                }
            } else {
                contextPath = request.getContextPath();
                if (contextPath == null || contextPath.equals("/")) {
                    contextPath = "";
                }
                errorPage = contextPath + "/carbon/admin/error.jsp?The Requested tenant domain: " + tenantDomain + " doesn't exist.";
                RequestDispatcher requestDispatcher = request.getRequestDispatcher(errorPage);
                requestDispatcher.forward((ServletRequest)request, servletResponse);
                return;
            }
            tenantExistMap.put(tenantDomain, true);
            request.setAttribute("tenantDomain", (Object)tenantDomain);
            if (path.indexOf("/admin/index.jsp") >= 0) {
                path = path.replaceAll("/admin/index.jsp", "/tenant-dashboard/index.jsp");
                request.setAttribute("tenant-sepcific-url-resolved", (Object)"1");
            }
            if (path.indexOf("admin/docs/userguide.html") >= 0) {
                path = path.replaceAll("admin/docs/userguide.html", "tenant-dashboard/docs/userguide.html");
                request.setAttribute("tenant-sepcific-url-resolved", (Object)"1");
            }
            if ("".equals(path) || "/".equals(path) || "/carbon".equals(path) || "/carbon/".equals(path) || "/carbon/admin".equals(path) || "/carbon/admin/".equals(path)) {
                path = "/t/" + tenantDomain + "/carbon/admin/login.jsp";
                ((HttpServletResponse)servletResponse).sendRedirect(path);
                return;
            }
            RequestDispatcher requestDispatcher = request.getRequestDispatcher(path);
            requestDispatcher.forward((ServletRequest)request, servletResponse);
            return;
        }
    }

    public void destroy() {
    }
}

