/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.task;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskDescriptionRepository;
import org.wso2.carbon.task.JobMetaDataProviderServiceHandler;
import org.wso2.carbon.task.TaskManagementServiceHandler;

public class TaskManager {
    private static final Log log = LogFactory.getLog(TaskManager.class);
    public static final String CARBON_TASK_MANAGER = "CARBON_TASK_MANAGER";
    public static final String CARBON_TASK_REPOSITORY = "CARBON_TASK_REPOSITORY";
    public static final String CARBON_TASK_JOB_METADATA_SERVICE = "CARBON_TASK_JOB_METADATA_SERVICE";
    public static final String CARBON_TASK_MANAGEMENT_SERVICE = "CARBON_TASK_MANAGEMENT_SERVICE";
    public static final String CARBON_TASK_SCHEDULER = "CARBON_TASK_SCHEDULER";
    private JobMetaDataProviderServiceHandler jobMetaDataProviderServiceHandler;
    private TaskManagementServiceHandler taskManagementServiceHandler;
    private boolean initialized = false;
    private TaskDescriptionRepository repository;

    public void init(JobMetaDataProviderServiceHandler jobMetaDataProviderServiceHandler, TaskManagementServiceHandler taskManagementServiceHandler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initiating a TaskManager");
        }
        this.jobMetaDataProviderServiceHandler = jobMetaDataProviderServiceHandler;
        this.taskManagementServiceHandler = taskManagementServiceHandler;
        this.initialized = true;
    }

    public void shutDown() {
        if (!this.initialized) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"TaskManager has not been initilized.");
            }
            return;
        }
        this.initialized = false;
    }

    public void addTaskDescription(TaskDescription taskDescription) {
        this.assetInitialized();
        String className = this.jobMetaDataProviderServiceHandler.getTaskManagementServiceImplementer(taskDescription.getGroup());
        if (className != null && !"".equals(className)) {
            this.taskManagementServiceHandler.addTaskDescription(taskDescription, className);
        }
    }

    public void deleteTaskDescription(String name, String group) {
        this.assetInitialized();
        String className = this.jobMetaDataProviderServiceHandler.getTaskManagementServiceImplementer(group);
        if (className != null && !"".equals(className)) {
            this.taskManagementServiceHandler.deleteTaskDescription(name, className);
        }
    }

    public void editTaskDescription(TaskDescription taskDescription) {
        this.assetInitialized();
        String className = this.jobMetaDataProviderServiceHandler.getTaskManagementServiceImplementer(taskDescription.getGroup());
        if (className != null && !"".equals(className)) {
            this.taskManagementServiceHandler.editTaskDescription(taskDescription, className);
        }
    }

    public List<TaskDescription> getAllTaskDescriptions() {
        this.assetInitialized();
        ArrayList<TaskDescription> taskDescriptions = new ArrayList<TaskDescription>();
        if (this.repository == null) {
            return taskDescriptions;
        }
        Iterator iterator = this.repository.getAllTaskDescriptions();
        while (iterator.hasNext()) {
            TaskDescription taskDescription = (TaskDescription)iterator.next();
            if (taskDescription == null) continue;
            taskDescriptions.add(taskDescription);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("All available Task based Startup " + taskDescriptions));
        }
        return taskDescriptions;
    }

    public TaskDescription getTaskDescription(String name, String group) {
        this.assetInitialized();
        String className = this.jobMetaDataProviderServiceHandler.getTaskManagementServiceImplementer(group);
        if (className != null && !"".equals(className)) {
            return this.taskManagementServiceHandler.getTaskDescription(name, className);
        }
        return null;
    }

    public boolean isContains(String name, String group) {
        this.assetInitialized();
        String className = this.jobMetaDataProviderServiceHandler.getTaskManagementServiceImplementer(group);
        return className != null && !"".equals(className) && this.taskManagementServiceHandler.isContains(name, className);
    }

    public List<String> getPropertyNames(String taskClass, String group) {
        this.assetInitialized();
        String className = this.jobMetaDataProviderServiceHandler.getTaskManagementServiceImplementer(group);
        if (className != null && !"".equals(className)) {
            return this.taskManagementServiceHandler.getPropertyNames(taskClass, className);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cannot find a property name list of class : " + taskClass));
        }
        return new ArrayList<String>();
    }

    public List<String> getAllJobGroups() {
        this.assetInitialized();
        return this.jobMetaDataProviderServiceHandler.getJobGroups();
    }

    public void setTaskDescriptionRepository(TaskDescriptionRepository repository) {
        this.repository = repository;
    }

    private void assetInitialized() {
        if (!this.initialized) {
            String msg = "TaskManager has not been initilized.Both of JobMetaDataProviderService and TaskManagementService should be provided to initiate the Task Manager";
            log.error((Object)msg);
            throw new IllegalStateException(msg);
        }
    }
}

