/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.stratos.landing.page.deployer;

import java.io.File;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.catalina.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.stratos.landing.page.deployer.internal.DataHolder;
import org.wso2.carbon.tomcat.CarbonTomcatException;

public class LandingPageWebappDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(LandingPageWebappDeployer.class);
    private final String LANDING_PAGE_WEBAPP_ROOT = "STRATOS_ROOT";
    public static final String WEBAPPS = "webapps";
    public static final String WEBAPP_CONTEXT = "home";

    public void init(ConfigurationContext configCtx) {
        String repoPath = configCtx.getAxisConfiguration().getRepository().getPath();
        String landingpageWebappDir = repoPath + WEBAPPS + File.separator + "STRATOS_ROOT";
        File webappFile = new File(landingpageWebappDir);
        if (webappFile.exists()) {
            DeploymentFileData landingpageAppFile = new DeploymentFileData(webappFile);
            try {
                this.deploy(landingpageAppFile);
            }
            catch (DeploymentException e) {
                log.error((Object)"Error while deploying landing page webapp.", (Throwable)e);
            }
        } else {
            log.warn((Object)"Product landing page not found.");
        }
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        String carbonWebContextRoot = "/home";
        if (deploymentFileData.getFile() != null) {
            Context context = null;
            try {
                context = DataHolder.getCarbonTomcatService().addWebApp(carbonWebContextRoot, deploymentFileData.getFile().getAbsolutePath(), null);
                log.info((Object)("Deployed product landing page webapp: " + context));
            }
            catch (CarbonTomcatException e) {
                String msg = "Webapp failed to deploy :" + deploymentFileData.getFile().getName();
                log.error((Object)msg, (Throwable)e);
                throw new DeploymentException(msg, (Throwable)e);
            }
        }
    }

    public void setDirectory(String repoDir) {
    }

    public void setExtension(String extension) {
    }

    public void undeploy(String fileName) throws DeploymentException {
    }

    public void cleanup() throws DeploymentException {
    }
}

