/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.keystore.mgt;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.keystore.mgt.KeyStoreGenerator;
import org.wso2.carbon.keystore.mgt.KeyStoreMgtException;
import org.wso2.carbon.stratos.common.beans.TenantInfoBean;
import org.wso2.carbon.stratos.common.exception.StratosException;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;

public class KeystoreTenantMgtListener
implements TenantMgtListener {
    private static Log log = LogFactory.getLog(KeystoreTenantMgtListener.class);
    private static final int EXEC_ORDER = 20;

    public void onTenantCreate(TenantInfoBean tenantInfo) throws StratosException {
        try {
            KeyStoreGenerator ksGenerator = new KeyStoreGenerator(tenantInfo.getTenantId());
            ksGenerator.generateKeyStore();
        }
        catch (KeyStoreMgtException e) {
            String message = "Error when generating the keystore";
            log.error((Object)message, (Throwable)e);
            throw new StratosException(message, (Throwable)e);
        }
    }

    public void onTenantUpdate(TenantInfoBean tenantInfo) throws StratosException {
    }

    public void onTenantRename(int tenantId, String oldDomainName, String newDomainName) throws StratosException {
    }

    public int getListenerOrder() {
        return 20;
    }

    public void onTenantInitialActivation(int tenantId) throws StratosException {
    }

    public void onTenantActivation(int tenantId) throws StratosException {
    }

    public void onTenantDeactivation(int tenantId) throws StratosException {
    }

    public void onSubscriptionPlanChange(int tenentId, String oldPlan, String newPlan) throws StratosException {
    }
}

