/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.captcha.mgt.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.captcha.mgt.util.CaptchaUtil;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.utils.ConfigurationContextService;

public class CaptchaMgtServiceComponent {
    private static Log log = LogFactory.getLog(CaptchaMgtServiceComponent.class);
    private static ConfigurationContextService configurationContextService;
    private static RegistryService registryService;

    protected void activate(ComponentContext context) {
        try {
            CaptchaUtil.setAnonAccessToCaptchaImages();
            if (log.isDebugEnabled()) {
                log.debug((Object)"*************Captcha Management component is activated.**************");
            }
        }
        catch (Exception e) {
            log.error((Object)"******* Captcha Management Component failed activating ****", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Captcha Management bundle is deactivated ******* ");
    }

    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"Receiving ConfigurationContext Service");
        CaptchaMgtServiceComponent.configurationContextService = configurationContextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"Unsetting ConfigurationContext Service");
        CaptchaMgtServiceComponent.configurationContextService = null;
    }

    public static ConfigurationContext getConfigurationContext() {
        if (configurationContextService.getServerConfigContext() == null) {
            return null;
        }
        return configurationContextService.getServerConfigContext();
    }

    protected void setRegistryService(RegistryService registryService) {
        CaptchaMgtServiceComponent.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        CaptchaMgtServiceComponent.registryService = null;
    }

    public static UserRegistry getConfigSystemRegistry(int tenantId) throws RegistryException {
        return registryService.getConfigSystemRegistry(tenantId);
    }
}

