/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.theme.mgt.services;

import java.util.ArrayList;
import java.util.Stack;
import javax.activation.DataHandler;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.common.utils.RegistryUtil;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.resource.beans.CollectionContentBean;
import org.wso2.carbon.registry.resource.beans.ContentBean;
import org.wso2.carbon.registry.resource.beans.ContentDownloadBean;
import org.wso2.carbon.registry.resource.beans.MetadataBean;
import org.wso2.carbon.registry.resource.beans.ResourceTreeEntryBean;
import org.wso2.carbon.registry.resource.services.utils.AddCollectionUtil;
import org.wso2.carbon.registry.resource.services.utils.AddResourceUtil;
import org.wso2.carbon.registry.resource.services.utils.AddTextResourceUtil;
import org.wso2.carbon.registry.resource.services.utils.ContentUtil;
import org.wso2.carbon.registry.resource.services.utils.DeleteUtil;
import org.wso2.carbon.registry.resource.services.utils.GetDownloadContentUtil;
import org.wso2.carbon.registry.resource.services.utils.GetResourceTreeEntryUtil;
import org.wso2.carbon.registry.resource.services.utils.GetTextContentUtil;
import org.wso2.carbon.registry.resource.services.utils.ImportResourceUtil;
import org.wso2.carbon.registry.resource.services.utils.MetadataPopulator;
import org.wso2.carbon.registry.resource.services.utils.RenameResourceUtil;
import org.wso2.carbon.registry.resource.services.utils.UpdateTextContentUtil;
import org.wso2.carbon.theme.mgt.util.ThemeUtil;

public class ThemeMgtService
extends AbstractAdmin {
    public ResourceTreeEntryBean getResourceTreeEntry(String resourcePath) throws Exception {
        UserRegistry themeRegistry = ThemeUtil.getThemeRegistry(this.getGovernanceSystemRegistry());
        return GetResourceTreeEntryUtil.getResourceTreeEntry((String)resourcePath, (UserRegistry)themeRegistry);
    }

    public ContentBean getContentBean(String path) throws Exception {
        UserRegistry themeRegistry = ThemeUtil.getThemeRegistry(this.getGovernanceSystemRegistry());
        return ContentUtil.getContent((String)path, (UserRegistry)themeRegistry);
    }

    public CollectionContentBean getCollectionContent(String path) throws Exception {
        UserRegistry themeRegistry = ThemeUtil.getThemeRegistry(this.getGovernanceSystemRegistry());
        return ContentUtil.getCollectionContent((String)path, (UserRegistry)themeRegistry);
    }

    public ResourceData[] getResourceData(String[] paths) throws Exception {
        UserRegistry themeRegistry = ThemeUtil.getThemeRegistry(this.getGovernanceSystemRegistry());
        return ContentUtil.getResourceData((String[])paths, (UserRegistry)themeRegistry);
    }

    public String addCollection(String parentPath, String collectionName, String mediaType, String description) throws Exception {
        UserRegistry registry = ThemeUtil.getThemeRegistry(this.getGovernanceSystemRegistry());
        return AddCollectionUtil.process((String)parentPath, (String)collectionName, (String)mediaType, (String)description, (UserRegistry)registry);
    }

    public void addResource(String path, String mediaType, String description, DataHandler content, String symlinkLocation, String tenantPass) throws Exception {
        UserRegistry registry = ThemeUtil.getThemeRegistry(this.getGovernanceSystemRegistry());
        if (registry == null) {
            registry = ThemeUtil.getThemeRegistryFromTenantPass(tenantPass);
        }
        AddResourceUtil.addResource((String)path, (String)mediaType, (String)description, (DataHandler)content, (String)symlinkLocation, (Registry)registry);
    }

    public void importResource(String parentPath, String resourceName, String mediaType, String description, String fetchURL, String symlinkLocation, String tenantPass) throws Exception {
        UserRegistry registry = ThemeUtil.getThemeRegistry(this.getGovernanceSystemRegistry());
        if (registry == null) {
            registry = ThemeUtil.getThemeRegistryFromTenantPass(tenantPass);
        }
        ImportResourceUtil.importResource((String)parentPath, (String)resourceName, (String)mediaType, (String)description, (String)fetchURL, (String)symlinkLocation, (UserRegistry)registry);
    }

    public void addTextResource(String parentPath, String fileName, String mediaType, String description, String content) throws Exception {
        UserRegistry registry = ThemeUtil.getThemeRegistry(this.getGovernanceSystemRegistry());
        AddTextResourceUtil.addTextResource((String)parentPath, (String)fileName, (String)mediaType, (String)description, (String)content, (UserRegistry)registry);
    }

    public MetadataBean getMetadata(String path) throws Exception {
        RegistryUtil.setSessionResourcePath((String)path);
        UserRegistry registry = ThemeUtil.getThemeRegistry(this.getGovernanceSystemRegistry());
        return MetadataPopulator.populate((String)path, (UserRegistry)registry);
    }

    public String getSessionResourcePath() throws Exception {
        return RegistryUtil.getSessionResourcePath();
    }

    public String getTextContent(String path) throws Exception {
        UserRegistry registry = ThemeUtil.getThemeRegistry(this.getGovernanceSystemRegistry());
        return GetTextContentUtil.getTextContent((String)path, (Registry)registry);
    }

    public void updateTextContent(String resourcePath, String contentText) throws Exception {
        UserRegistry registry = ThemeUtil.getThemeRegistry(this.getGovernanceSystemRegistry());
        UpdateTextContentUtil.updateTextContent((String)resourcePath, (String)contentText, (Registry)registry);
    }

    public ContentDownloadBean getContentDownloadBean(String path) throws Exception {
        UserRegistry registry = ThemeUtil.getThemeRegistry(this.getGovernanceSystemRegistry());
        return GetDownloadContentUtil.getContentDownloadBean((String)path, (UserRegistry)registry);
    }

    public void renameResource(String parentPath, String oldResourcePath, String newResourceName) throws Exception {
        UserRegistry registry = ThemeUtil.getThemeRegistry(this.getGovernanceSystemRegistry());
        RenameResourceUtil.renameResource((String)parentPath, (String)oldResourcePath, (String)newResourceName, (UserRegistry)registry);
    }

    public void delete(String pathToDelete) throws Exception {
        UserRegistry registry = ThemeUtil.getThemeRegistry(this.getGovernanceSystemRegistry());
        DeleteUtil.process((String)pathToDelete, (UserRegistry)registry);
    }

    public String[] getAllPaths() throws Exception {
        UserRegistry registry = ThemeUtil.getThemeRegistry(this.getGovernanceSystemRegistry());
        ArrayList<String> paths = new ArrayList<String>();
        Stack<Collection> parentCollections = new Stack<Collection>();
        Collection rootCollection = (Collection)registry.get("/");
        parentCollections.push(rootCollection);
        while (!parentCollections.empty()) {
            String[] childs;
            Collection parentCollection = (Collection)parentCollections.pop();
            for (String childPath : childs = parentCollection.getChildren()) {
                String pathToAdd = childPath.substring(1);
                paths.add(pathToAdd);
                Resource resource = registry.get(childPath);
                if (!(resource instanceof Collection)) continue;
                Collection c = (Collection)resource;
                parentCollections.push(c);
            }
        }
        return paths.toArray(new String[paths.size()]);
    }

    public String[] getAllThemes(String tenantPass) throws Exception {
        String[] allThemes = ThemeUtil.getAvailableThemes();
        String currentTheme = ThemeUtil.getCurrentTheme(tenantPass, (UserRegistry)this.getGovernanceSystemRegistryIfLoggedIn());
        String[] returnVal = new String[allThemes.length + 1];
        returnVal[0] = currentTheme;
        for (int i = 0; i < allThemes.length; ++i) {
            returnVal[i + 1] = allThemes[i];
        }
        return returnVal;
    }

    public void applyTheme(String themeName, String tenantPass) throws Exception {
        ThemeUtil.applyTheme(themeName, tenantPass, (UserRegistry)this.getGovernanceSystemRegistryIfLoggedIn());
        ThemeUtil.removeTheUUID(tenantPass);
    }

    private Registry getGovernanceSystemRegistryIfLoggedIn() {
        UserRegistry tempRegistry = (UserRegistry)this.getConfigUserRegistry();
        if (tempRegistry != null) {
            try {
                return ThemeUtil.getRegistryService().getGovernanceSystemRegistry(tempRegistry.getTenantId());
            }
            catch (Exception ignored) {
                return null;
            }
        }
        return null;
    }
}

