/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.activation.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.activation.utils.ActivationManager;
import org.wso2.carbon.activation.utils.Util;
import org.wso2.carbon.stratos.common.config.CloudServiceConfig;
import org.wso2.carbon.stratos.common.config.CloudServiceConfigParser;
import org.wso2.carbon.stratos.common.config.CloudServicesDescConfig;
import org.wso2.carbon.stratos.common.util.CloudServicesUtil;

public class ActivationService {
    private static final Log log = LogFactory.getLog(ActivationService.class);

    public static void updateActivation(int tenantId) throws Exception {
        if (tenantId != 0) {
            String serviceName = Util.getServiceName();
            boolean isActive = CloudServicesUtil.isCloudServiceActive((String)serviceName, (int)tenantId);
            CloudServicesDescConfig cloudServicesDesc = CloudServiceConfigParser.loadCloudServicesConfiguration();
            CloudServicesUtil.setCloudServiceActive((!isActive ? 1 : 0) != 0, (String)serviceName, (int)tenantId, (CloudServiceConfig)((CloudServiceConfig)cloudServicesDesc.getCloudServiceConfigs().get(serviceName)));
            ActivationManager.setActivation(tenantId, !isActive);
        }
    }

    public boolean isActive(int tenantId) throws Exception {
        if (tenantId == -1234) {
            return true;
        }
        if (ActivationManager.activationRecorded(tenantId)) {
            return ActivationManager.getActivation(tenantId);
        }
        String serviceName = Util.getServiceName();
        if (CloudServicesUtil.isCloudServiceActive((String)serviceName, (int)tenantId)) {
            log.debug((Object)("Successful attempt to access " + serviceName + " by tenant " + tenantId));
            ActivationManager.setActivation(tenantId, true);
            return true;
        }
        log.warn((Object)("Failed attempt to access " + serviceName + " by tenant " + tenantId));
        ActivationManager.setActivation(tenantId, false);
        return false;
    }
}

