/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.activation.internal;

import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.activation.service.ActivationService;
import org.wso2.carbon.activation.utils.ActivationManager;
import org.wso2.carbon.activation.utils.Util;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class ActivationServiceComponent {
    private static final Log log = LogFactory.getLog(ActivationServiceComponent.class);
    private static ServiceRegistration registration = null;

    protected void activate(ComponentContext context) {
        try {
            ActivationManager.startCacheCleaner();
            if (registration == null) {
                registration = context.getBundleContext().registerService(ActivationService.class.getName(), (Object)new ActivationService(), null);
            }
            log.debug((Object)"******* Stratos Activation bundle is activated ******* ");
        }
        catch (Exception e) {
            log.error((Object)"******* Stratos Activation bundle failed activating ****", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext context) {
        registration.unregister();
        registration = null;
        ActivationManager.stopCacheCleaner();
        log.debug((Object)"******* Stratos Activation bundle is deactivated ******* ");
    }

    protected void setRegistryService(RegistryService registryService) {
        Util.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        Util.setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        Util.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        Util.setRealmService(null);
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        try {
            if (contextService.getServerConfigContext() != null && contextService.getServerConfigContext().getAxisConfiguration() != null) {
                contextService.getServerConfigContext().getAxisConfiguration().engageModule("activation");
            } else {
                log.error((Object)"Failed to engage Activation Module.");
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Failed to engage Activation Module", (Throwable)e);
        }
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
    }
}

