/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttling.agent.internal;

import java.util.ArrayList;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.stratos.common.util.StratosConfiguration;
import org.wso2.carbon.throttling.agent.ThrottlingAgent;
import org.wso2.carbon.throttling.agent.cache.Axis2ConfigurationContextObserverImpl;
import org.wso2.carbon.throttling.agent.cache.ThrottlingInfoCache;
import org.wso2.carbon.throttling.agent.listeners.WebAppRequestListener;
import org.wso2.carbon.tomcat.ext.valves.TomcatValveContainer;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

public class ThrottlingAgentServiceComponent {
    private static Log log = LogFactory.getLog(ThrottlingAgentServiceComponent.class);
    private static ThrottlingAgent throttlingAgent;
    private static RealmService realmService;
    private static RegistryService registryService;
    private static ConfigurationContextService contextService;
    private static StratosConfiguration stratosConfiguration;

    protected void activate(ComponentContext context) {
        try {
            BundleContext bundleContext = context.getBundleContext();
            throttlingAgent = new ThrottlingAgent(bundleContext);
            throttlingAgent.setConfigurationContextService(contextService);
            throttlingAgent.setRealmService(realmService);
            throttlingAgent.setRegistryService(registryService);
            throttlingAgent.setStratosConfiguration(stratosConfiguration);
            try {
                throttlingAgent.init();
            }
            catch (RegistryException e) {
                String errMessage = "Failed to initialize throttling agent.";
                log.error((Object)errMessage, (Throwable)e);
                throw new RuntimeException(errMessage, e);
            }
            ArrayList<WebAppRequestListener> valves = new ArrayList<WebAppRequestListener>();
            valves.add(new WebAppRequestListener(throttlingAgent));
            TomcatValveContainer.addValves(valves);
            this.registerAxis2ConfigurationContextObserver(bundleContext, throttlingAgent.getThrottlingInfoCache());
            this.registerThrottlingAgent(bundleContext);
            log.debug((Object)"******* Multitenancy Throttling Agent bundle is activated ******* ");
        }
        catch (Throwable e) {
            log.error((Object)"******* Multitenancy Throttling Agent bundle failed activating ****", e);
        }
    }

    private void registerAxis2ConfigurationContextObserver(BundleContext bundleContext, ThrottlingInfoCache cache) {
        bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new Axis2ConfigurationContextObserverImpl(cache), null);
    }

    public void registerThrottlingAgent(BundleContext bundleContext) {
        try {
            bundleContext.registerService(ThrottlingAgent.class.getName(), (Object)throttlingAgent, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Multitenancy Throttling Agent bundle is deactivated ******* ");
    }

    protected void setRegistryService(RegistryService registryService) {
        ThrottlingAgentServiceComponent.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        ThrottlingAgentServiceComponent.registryService = null;
        throttlingAgent.setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        ThrottlingAgentServiceComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        ThrottlingAgentServiceComponent.realmService = null;
        throttlingAgent.setRealmService(null);
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        ThrottlingAgentServiceComponent.contextService = contextService;
        try {
            contextService.getServerConfigContext().getAxisConfiguration().engageModule("usagethrottling");
        }
        catch (AxisFault e) {
            log.error((Object)"Failed to engage usage throttling module", (Throwable)e);
        }
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        try {
            AxisConfiguration axisConfig = contextService.getServerConfigContext().getAxisConfiguration();
            axisConfig.disengageModule(axisConfig.getModule("usagethrottling"));
        }
        catch (AxisFault e) {
            log.error((Object)"Failed to disengage usage throttling module", (Throwable)e);
        }
        ThrottlingAgentServiceComponent.contextService = null;
        throttlingAgent.setConfigurationContextService(null);
    }

    public static ThrottlingAgent getThrottlingAgent() {
        return throttlingAgent;
    }

    protected void setStratosConfigurationService(StratosConfiguration stratosConfigService) {
        stratosConfiguration = stratosConfigService;
    }

    protected void unsetStratosConfigurationService(StratosConfiguration ccService) {
        stratosConfiguration = null;
        throttlingAgent.setStratosConfiguration(null);
    }
}

