/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso.ui.builders;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml2.core.impl.SubjectBuilder;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.SAML2SSOUIAuthenticatorException;
import org.wso2.carbon.identity.authenticator.saml2.sso.ui.Util;

public class AuthenticationRequestBuilder {
    private static Log log = LogFactory.getLog(AuthenticationRequestBuilder.class);

    public AuthnRequest buildAuthenticationRequest(String subjectName) throws SAML2SSOUIAuthenticatorException {
        Util.doBootstrap();
        AuthnRequest authnRequest = (AuthnRequest)Util.buildXMLObject(AuthnRequest.DEFAULT_ELEMENT_NAME);
        authnRequest.setID(Util.createID());
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        authnRequest.setIssueInstant(new DateTime());
        authnRequest.setIssuer(AuthenticationRequestBuilder.buildIssuer());
        authnRequest.setNameIDPolicy(AuthenticationRequestBuilder.buildNameIDPolicy());
        if (subjectName != null) {
            Subject subject = new SubjectBuilder().buildObject();
            NameID nameId = new NameIDBuilder().buildObject();
            nameId.setValue(subjectName);
            nameId.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
            subject.setNameID(nameId);
            authnRequest.setSubject(subject);
        }
        return authnRequest;
    }

    private static Issuer buildIssuer() {
        IssuerBuilder issuerBuilder = new IssuerBuilder();
        Issuer issuer = issuerBuilder.buildObject();
        issuer.setValue(Util.getServiceProviderId());
        return issuer;
    }

    private static NameIDPolicy buildNameIDPolicy() {
        NameIDPolicy nameIDPolicy = new NameIDPolicyBuilder().buildObject();
        nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        nameIDPolicy.setAllowCreate(Boolean.valueOf(true));
        return nameIDPolicy;
    }
}

