/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.upload;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.application.upload.UploadedFileItem;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.utils.CarbonUtils;

public class CarbonAppUploader
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(CarbonAppUploader.class);

    public void uploadApp(UploadedFileItem[] fileItems) throws AxisFault {
        try {
            String carbonHome = CarbonUtils.getCarbonHome();
            String carbonAppDir = carbonHome + File.separator + "repository" + File.separator + "carbonapps";
            this.createDir(carbonAppDir);
            String carbonHomeTmp = carbonHome + File.separator + "tmp";
            this.createDir(carbonHomeTmp);
            String carbonAppDirTemp = carbonHomeTmp + File.separator + "carbonappsuploads";
            this.createDir(carbonAppDirTemp);
            for (UploadedFileItem uploadedFile : fileItems) {
                String fileName = uploadedFile.getFileName();
                if (fileName == null || fileName.equals("")) {
                    throw new AxisFault("Invalid file name");
                }
                if (!uploadedFile.getFileType().equals("jar")) {
                    throw new AxisFault("Invalid file type : " + uploadedFile.getFileType());
                }
                this.writeResource(uploadedFile.getDataHandler(), carbonAppDirTemp, carbonAppDir, fileName);
            }
        }
        catch (Exception e) {
            String msg = "Error occurred while uploading Carbon App artifacts";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResource(DataHandler dataHandler, String tempDestPath, String destPath, String fileName) throws IOException {
        File tempDestFile = new File(tempDestPath, fileName);
        AbstractInterruptibleChannel out = null;
        AbstractInterruptibleChannel in = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(tempDestFile);
            dataHandler.writeTo((OutputStream)fos);
            fos.flush();
            dataHandler.writeTo((OutputStream)fos);
            out = new FileOutputStream(destPath + File.separator + fileName).getChannel();
            in = new FileInputStream(tempDestFile).getChannel();
            ((FileChannel)out).write(((FileChannel)in).map(FileChannel.MapMode.READ_ONLY, 0L, ((FileChannel)in).size()));
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Can't close file streams.", (Throwable)e);
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Can't close file streams.", (Throwable)e);
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Can't close file streams.", (Throwable)e);
            }
        }
        if (!tempDestFile.delete()) {
            log.warn((Object)("temp file: " + tempDestFile.getAbsolutePath() + " deletion failed, scheduled deletion on server exit."));
            tempDestFile.deleteOnExit();
        }
    }

    private void createDir(String path) throws Exception {
        File temp = new File(path);
        if (!temp.exists() && !temp.mkdir()) {
            String msg = "Error while creating directory : " + path;
            log.error((Object)msg);
            throw new Exception(msg);
        }
    }
}

