/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tenant.mgt.services;

import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.captcha.mgt.beans.CaptchaInfoBean;
import org.wso2.carbon.captcha.mgt.util.CaptchaUtil;
import org.wso2.carbon.core.multitenancy.persistence.TenantPersistor;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.stratos.common.beans.TenantInfoBean;
import org.wso2.carbon.stratos.common.exception.StratosException;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.tenant.mgt.internal.TenantMgtServiceComponent;
import org.wso2.carbon.tenant.mgt.util.TenantMgtUtil;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class TenantSelfRegistrationService {
    private static final Log log = LogFactory.getLog(TenantSelfRegistrationService.class);

    public String registerTenant(TenantInfoBean tenantInfoBean, CaptchaInfoBean captchaInfoBean) throws Exception {
        try {
            CommonUtil.validateEmail((String)tenantInfoBean.getEmail());
        }
        catch (Exception e) {
            String msg = "Invalid email is provided.";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
        String domainName = tenantInfoBean.getTenantDomain();
        try {
            TenantMgtUtil.validateDomain(domainName);
        }
        catch (Exception e) {
            String msg = "Domain Validation Failed.";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
        String firstname = tenantInfoBean.getFirstname();
        String lastname = tenantInfoBean.getLastname();
        try {
            CommonUtil.validateName((String)firstname, (String)"First Name");
            CommonUtil.validateName((String)lastname, (String)"Last Name");
        }
        catch (Exception e) {
            String msg = "First/Last Name Validation Failed.";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
        try {
            CaptchaUtil.validateCaptcha((CaptchaInfoBean)captchaInfoBean);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Captcha Successfully Validated.");
            }
        }
        catch (Exception e) {
            String msg = "Captcha validation failed.";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
        finally {
            try {
                CaptchaUtil.cleanCaptcha((String)captchaInfoBean.getSecretKey());
            }
            catch (Exception e) {
                String msg = "Error in cleaning captcha. ";
                log.error((Object)msg, (Throwable)e);
            }
        }
        Tenant tenant = TenantMgtUtil.initializeTenant(tenantInfoBean);
        TenantPersistor persistor = TenantMgtServiceComponent.getTenantPersistor();
        int tenantId = persistor.persistTenant(tenant, true, tenantInfoBean.getSuccessKey(), tenantInfoBean.getOriginatedService());
        tenantInfoBean.setTenantId(tenantId);
        TenantMgtUtil.addClaimsToUserStoreManager(tenant);
        try {
            TenantMgtUtil.triggerAddTenant(tenantInfoBean);
        }
        catch (StratosException e) {
            String msg = "Error in notifying tenant addition.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        try {
            if (TenantMgtServiceComponent.getBillingService() != null) {
                TenantMgtServiceComponent.getBillingService().addUsagePlan((org.wso2.carbon.user.api.Tenant)tenant, tenantInfoBean.getUsagePlan());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Subscription added successfully for the tenant: " + tenantInfoBean.getTenantDomain()));
                }
            }
        }
        catch (Exception e) {
            String msg = "Error occurred while adding the subscription for tenant: " + domainName;
            log.error((Object)msg, (Throwable)e);
        }
        if (CommonUtil.isTenantManagementEmailsDisabled() || !CommonUtil.isEmailValidationMandatory()) {
            TenantMgtUtil.activateTenantInitially(tenantInfoBean, tenantId);
        }
        return TenantMgtUtil.prepareStringToShowThemeMgtPage(tenant.getId());
    }

    public boolean checkDomainAvailability(String domainName) throws Exception {
        TenantManager tenantManager = TenantMgtServiceComponent.getTenantManager();
        int tenantId = tenantManager.getTenantId(domainName);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Tenant Domain is available to register.");
        }
        return tenantId < 0;
    }

    public String validateOrSuggestDomain(String domain, String successKey) throws Exception {
        if (successKey != null && !successKey.equals("") && CommonUtil.validateDomainFromSuccessKey((UserRegistry)TenantMgtServiceComponent.getGovernanceSystemRegistry(-1234), (String)domain, (String)successKey)) {
            return domain;
        }
        return "null";
    }

    public CaptchaInfoBean generateRandomCaptcha() throws Exception {
        CaptchaUtil.cleanOldCaptchas();
        return CaptchaUtil.generateCaptchaImage();
    }
}

