/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.agent.listeners.axis2;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.transports.metering.MeteredServletRequest;
import org.wso2.carbon.usage.agent.util.Util;
import org.wso2.carbon.user.api.UserStoreException;

public class RequestMeteringHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(RequestMeteringHandler.class);

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Staring metering handler invocation. Incoming message: " + messageContext.getEnvelope().toString()));
        }
        AxisService service = messageContext.getAxisService();
        Parameter param = service.getParameter("adminService");
        Object obj = messageContext.getProperty("transport.http.servletRequest");
        if (obj == null) {
            log.debug((Object)"Servlet request is null. Skip monitoring.");
            return Handler.InvocationResponse.CONTINUE;
        }
        if (!(obj instanceof MeteredServletRequest)) {
            log.debug((Object)"HttpServletRequest is not of type MeteredServletRequest. Skip monitoring.");
            return Handler.InvocationResponse.CONTINUE;
        }
        MeteredServletRequest servletRequest = (MeteredServletRequest)obj;
        if (param != null && "true".equals(param.getValue())) {
            servletRequest.setAttribute("adminService", (Object)"true");
            return Handler.InvocationResponse.CONTINUE;
        }
        servletRequest.setAttribute("meteringServiceName", (Object)service.getName());
        int tenantId = this.getTenantId(servletRequest);
        servletRequest.setAttribute("tenantId", (Object)tenantId);
        return Handler.InvocationResponse.CONTINUE;
    }

    private int getTenantId(MeteredServletRequest servletRequest) {
        int domainNameEndIndex;
        int domainNameStartIndex;
        String domainName;
        String address = servletRequest.getRequestURI();
        String servicesPrefix = "/services/t/";
        if (address != null && address.contains(servicesPrefix) && (domainName = address.substring(domainNameStartIndex, (domainNameEndIndex = address.indexOf(47, domainNameStartIndex = address.indexOf(servicesPrefix) + servicesPrefix.length())) == -1 ? address.length() : domainNameEndIndex)) != null) {
            try {
                return Util.getRealmService().getTenantManager().getTenantId(domainName);
            }
            catch (UserStoreException e) {
                log.error((Object)"An error occurred while obtaining the tenant id.", (Throwable)e);
            }
        }
        return 0;
    }
}

