/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.agent.api;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.usage.agent.exception.UsageException;

public class CustomMeteringAgent {
    private static final Log log = LogFactory.getLog(CustomMeteringAgent.class);
    private Registry registry;

    public CustomMeteringAgent(Registry registry) {
        this.registry = registry;
    }

    public String[] getRecordedDurations(String measurement) throws UsageException {
        String[] durations;
        String measurementCollectionPath = "/repository/components/org.wso2.carbon.system-metering/" + measurement;
        try {
            Resource resource = this.registry.get(measurementCollectionPath);
            if (!(resource instanceof Collection)) {
                String msg = "The records collection is not a registry collection. path: " + measurementCollectionPath + ".";
                log.error((Object)msg);
                throw new UsageException(msg);
            }
            durations = ((Collection)resource).getChildren();
        }
        catch (RegistryException e) {
            String msg = "Error in checking the usage entry exists. measurement: " + measurement + ".";
            log.error((Object)msg, (Throwable)e);
            throw new UsageException(msg, (Exception)((Object)e));
        }
        return durations;
    }

    public boolean isUsageEntryExists(String duration, String measurement) throws UsageException {
        if (duration == null) {
            duration = "anyDuration";
        }
        String measurementPath = "/repository/components/org.wso2.carbon.system-metering/" + measurement + "/" + duration;
        try {
            if (this.registry.resourceExists(measurementPath)) {
                return true;
            }
        }
        catch (RegistryException e) {
            String msg = "Error in checking the usage entry exists. measurement: " + measurement + ".";
            log.error((Object)msg, (Throwable)e);
            throw new UsageException(msg, (Exception)((Object)e));
        }
        return false;
    }

    public void persistUsage(String duration, String measurement, String value) throws UsageException {
        if (duration == null) {
            duration = "anyDuration";
        }
        String measurementPath = "/repository/components/org.wso2.carbon.system-metering/" + measurement + "/" + duration;
        try {
            Resource measurementResource = this.registry.newResource();
            ((ResourceImpl)measurementResource).setVersionableChange(false);
            measurementResource.setContent((Object)value);
            this.registry.put(measurementPath, measurementResource);
        }
        catch (RegistryException e) {
            String msg = "Error in persisting the usage. measurement: " + measurement + ".";
            log.error((Object)msg, (Throwable)e);
            throw new UsageException(msg, (Exception)((Object)e));
        }
    }

    public String retrieveUsage(String duration, String measurement) throws UsageException {
        String usageValue;
        String measurementPath = "/repository/components/org.wso2.carbon.system-metering/" + measurement + "/" + duration;
        try {
            Resource measurementResource = this.registry.get(measurementPath);
            byte[] contentBytes = (byte[])measurementResource.getContent();
            usageValue = new String(contentBytes);
        }
        catch (RegistryException e) {
            String msg = "Error in retrieving the usage. measurement: " + measurement + ".";
            log.error((Object)msg, (Throwable)e);
            throw new UsageException(msg, (Exception)((Object)e));
        }
        return usageValue;
    }

    public long addUsage(String duration, String measurement, long value) throws UsageException {
        if (duration == null) {
            duration = "anyDuration";
        }
        boolean transactionSuccess = false;
        try {
            this.registry.beginTransaction();
            if (this.isUsageEntryExists(duration, measurement)) {
                String usageStr = this.retrieveUsage(duration, measurement);
                try {
                    long storedValue = Long.parseLong(usageStr);
                    value += storedValue;
                }
                catch (NumberFormatException e) {
                    String msg = "Error in parsing the integer string: " + usageStr;
                    log.error((Object)msg, (Throwable)e);
                    throw new RegistryException(msg, (Throwable)e);
                }
            }
            String valueStr = Long.toString(value);
            this.persistUsage(duration, measurement, valueStr);
            transactionSuccess = true;
        }
        catch (RegistryException e) {
            String msg = "Error in invoking the add usage. measurement: " + measurement + ".";
            log.error((Object)msg, (Throwable)e);
            throw new UsageException(msg, (Exception)((Object)e));
        }
        finally {
            try {
                if (transactionSuccess) {
                    this.registry.commitTransaction();
                } else {
                    this.registry.rollbackTransaction();
                }
            }
            catch (RegistryException e) {
                String msg = "Error in commiting/rollbacking the transaction";
                log.error((Object)msg, (Throwable)e);
            }
        }
        return value;
    }
}

