/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.installer;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.servlet.http.HttpSession;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.application.upload.CarbonAppUploader;
import org.wso2.carbon.application.upload.UploadedFileItem;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.registry.core.utils.RegistryClientUtils;
import org.wso2.carbon.sample.installer.beans.SampleInformation;
import org.wso2.carbon.sample.installer.utils.Util;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;

public class SampleDeployer
extends CarbonAppUploader {
    private static final Log log = LogFactory.getLog(SampleDeployer.class);
    private static final String REGISTRY_SAMPLE_LOCATION = "/samples/";
    private static final String APP_ARCHIVE_EXTENSION = ".car";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deploySample(String sampleName, String tenantDomain) throws AxisFault, org.wso2.carbon.registry.core.exceptions.RegistryException {
        SuperTenantCarbonContext.startTenantFlow();
        try {
            SuperTenantCarbonContext carbonContext = SuperTenantCarbonContext.getCurrentContext();
            SuperTenantCarbonContext carbonContextOnMessageContext = SuperTenantCarbonContext.getCurrentContext((MessageContext)MessageContext.getCurrentMessageContext());
            carbonContextOnMessageContext.setTenantDomain(tenantDomain, true);
            BundleContext bundleContext = Util.getBundleContext();
            if (bundleContext != null) {
                ServiceTracker tracker = new ServiceTracker(bundleContext, TenantRegistryLoader.class.getName(), null);
                tracker.open();
                Object[] services = tracker.getServices();
                if (services != null) {
                    for (Object service : services) {
                        ((TenantRegistryLoader)service).loadTenantRegistry(carbonContextOnMessageContext.getTenantId());
                    }
                }
                tracker.close();
            }
            carbonContext.setTenantDomain(tenantDomain, true);
            int tenantId = Util.getRealmService().getTenantManager().getTenantId(tenantDomain);
            String pathToAuthorize = "/_system/governance/policies/policy_service.xml";
            Util.getRealmService().getTenantUserRealm(tenantId).getAuthorizationManager().authorizeRole("wso2.anonymous.role", pathToAuthorize, "http://www.wso2.org/projects/registry/actions/get");
            Resource sampleFile = (Resource)carbonContext.getRegistry(RegistryType.SYSTEM_GOVERNANCE).get(this.getSamplePath(sampleName));
            UploadedFileItem[] fileItems = new UploadedFileItem[]{new UploadedFileItem()};
            fileItems[0].setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource((byte[])sampleFile.getContent(), "application/octet-stream")));
            fileItems[0].setFileName(sampleName + APP_ARCHIVE_EXTENSION);
            fileItems[0].setFileType("jar");
            this.uploadApp(fileItems);
            boolean bl = true;
            return bl;
        }
        catch (RegistryException e) {
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(e.getMessage(), (Throwable)e);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            log.error((Object)"Failed to set permission", (Throwable)e);
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
            return false;
        }
    }

    public void setPolicyPermission() {
        try {
            log.info((Object)("Setting policy permission for tenant " + this.getTenantDomain()));
            this.getUserRealm().getAuthorizationManager().authorizeRole("wso2.anonymous.role", "/_system/governance/policies", "http://www.wso2.org/projects/registry/actions/get");
        }
        catch (UserStoreException e) {
            e.printStackTrace();
        }
    }

    private HttpSession getSession() {
        return (HttpSession)MessageContext.getCurrentMessageContext().getProperty("comp.mgt.servlet.session");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadSample(String sampleName, String tenantDomain) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            String tenantSpecificPath;
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantDomain(tenantDomain, true);
            SuperTenantCarbonContext.getCurrentContext().getTenantId(true);
            Registry registry = (Registry)SuperTenantCarbonContext.getCurrentContext().getRegistry(RegistryType.SYSTEM_GOVERNANCE);
            try {
                if (registry.resourceExists(this.getSamplePath(sampleName))) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            String path = CarbonUtils.getCarbonHome() + File.separator + "samples" + File.separator + "bin" + File.separator + sampleName + APP_ARCHIVE_EXTENSION;
            try {
                long start = System.nanoTime();
                tenantSpecificPath = Util.generateAppArchiveForTenant(path, this.getSession());
                if (log.isInfoEnabled()) {
                    log.info((Object)("Generated Sample for Tenant in " + (System.nanoTime() - start) / 1000L / 1000L + "ms"));
                }
            }
            catch (IOException e) {
                log.error((Object)"Failed to generate sample for tenant", (Throwable)e);
                boolean bl = false;
                SuperTenantCarbonContext.endTenantFlow();
                return bl;
            }
            try {
                File sampleFile = new File(tenantSpecificPath);
                RegistryClientUtils.importToRegistry((File)sampleFile, (String)REGISTRY_SAMPLE_LOCATION, (Registry)registry);
            }
            finally {
                if (!path.equals(tenantSpecificPath)) {
                    try {
                        FileUtils.deleteDirectory((File)new File(tenantSpecificPath).getParentFile());
                    }
                    catch (IOException e) {
                        log.warn((Object)"Unable to delete temporary file", (Throwable)e);
                    }
                }
            }
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
        return true;
    }

    public SampleInformation[] getSampleInformation(String tenantDomain) {
        SampleInformation[] samples;
        for (SampleInformation sample : samples = Util.getSampleInformation()) {
            String[] services = sample.getServiceEPRs();
            LinkedList<String> serviceList = new LinkedList<String>();
            for (String service : services) {
                serviceList.add(service + "/services/");
            }
            sample.setServiceEPRs(serviceList.toArray(new String[serviceList.size()]));
            String[] serviceNames = sample.getRequiredServices();
            boolean installable = true;
            if (serviceNames.length > 0) {
                int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
                for (String serviceName : serviceNames) {
                    try {
                        if (Util.isCloudServiceActive(serviceName, tenantId)) continue;
                        installable = false;
                    }
                    catch (Exception ignored) {
                        installable = false;
                    }
                    break;
                }
            }
            sample.setInstallable(installable);
        }
        return samples;
    }

    private String getSamplePath(String sampleName) {
        return REGISTRY_SAMPLE_LOCATION + sampleName + APP_ARCHIVE_EXTENSION;
    }
}

