/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.internal.core;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.status.monitor.beans.ServiceStateDetailInfoBean;
import org.wso2.carbon.status.monitor.beans.ServiceStateInfoBean;
import org.wso2.carbon.status.monitor.core.jdbc.MySQLConnectionInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLConnector {
    private static Connection conn;
    private static final Log log;
    private static List<String> serviceList;
    private static List<String> statusList;

    public static Connection initialize() throws Exception {
        conn = MySQLConnectionInitializer.initialize();
        serviceList = MySQLConnectionInitializer.getServiceList();
        statusList = MySQLConnectionInitializer.getStatusList();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Connection to the status database is initialized from status.monitor");
        }
        return conn;
    }

    public static ServiceStateInfoBean getServiceState(int serviceID) throws SQLException {
        Statement stmtCon = conn.createStatement();
        String sql = "SELECT * FROM WSL_SERVICE_STATE WHERE WSL_SERVICE_ID=" + serviceID + " ORDER BY WSL_TIMESTAMP DESC LIMIT 1";
        stmtCon.executeQuery(sql);
        ResultSet rs = stmtCon.getResultSet();
        ServiceStateInfoBean serviceStateInfoBean = new ServiceStateInfoBean();
        try {
            while (rs.next()) {
                int stateID = rs.getInt("WSL_STATE_ID");
                Timestamp date = rs.getTimestamp("WSL_TIMESTAMP");
                serviceStateInfoBean.setDate(date.getTime());
                serviceStateInfoBean.setService(serviceList.get(serviceID - 1));
                serviceStateInfoBean.setServiceID(serviceID);
                serviceStateInfoBean.setServiceState(statusList.get(stateID - 1));
            }
        }
        catch (SQLException e) {
            String msg = "Getting the service state failed";
            log.error((Object)msg, (Throwable)e);
            throw new SQLException(msg, e);
        }
        finally {
            rs.close();
            stmtCon.close();
        }
        return serviceStateInfoBean;
    }

    public static List<ServiceStateDetailInfoBean> getAllServiceStateDetail() throws Exception {
        ArrayList<ServiceStateDetailInfoBean> stateDetailList = new ArrayList<ServiceStateDetailInfoBean>();
        Statement stmtCon = conn.createStatement();
        String sql = "select s.WSL_NAME, ss.WSL_TIMESTAMP, ssd.WSL_DETAIL, ssd.WSL_TIMESTAMP from WSL_SERVICE as s, WSL_SERVICE_STATE as ss, WSL_SERVICE_STATE_DETAIL as ssd where s.WSL_ID = ss.WSL_SERVICE_ID AND ss.WSL_ID = ssd.WSL_SERVICE_STATE_ID AND (ss.WSL_STATE_ID=2 OR ss.WSL_STATE_ID=3) order by ss.WSL_TIMESTAMP DESC";
        stmtCon.executeQuery(sql);
        ResultSet rs = stmtCon.getResultSet();
        try {
            while (rs.next()) {
                ServiceStateDetailInfoBean serviceStateDetailInfoBean = new ServiceStateDetailInfoBean();
                String service = rs.getString("s.WSL_NAME");
                Timestamp stateLoggedTime = rs.getTimestamp("ss.WSL_TIMESTAMP");
                Timestamp detailLoggedTime = rs.getTimestamp("ssd.WSL_TIMESTAMP");
                String serviceStateDetail = rs.getString("ssd.WSL_DETAIL");
                serviceStateDetailInfoBean.setService(service);
                serviceStateDetailInfoBean.setStateLoggedTime(stateLoggedTime.getTime());
                serviceStateDetailInfoBean.setServiceStateDetail(serviceStateDetail);
                serviceStateDetailInfoBean.setDetailLoggedTime(detailLoggedTime.getTime());
                stateDetailList.add(serviceStateDetailInfoBean);
            }
        }
        catch (SQLException e) {
            String msg = "Getting the serviceID failed";
            log.error((Object)msg, (Throwable)e);
            throw new SQLException(msg, e);
        }
        finally {
            rs.close();
            stmtCon.close();
        }
        return stateDetailList;
    }

    public static List<ServiceStateInfoBean> getAllServiceState() throws Exception {
        ArrayList<ServiceStateInfoBean> serviceStateInfoBeanList = new ArrayList<ServiceStateInfoBean>();
        for (int serviceID = 1; serviceID <= serviceList.size(); ++serviceID) {
            serviceStateInfoBeanList.add(MySQLConnector.getServiceState(serviceID));
        }
        return serviceStateInfoBeanList;
    }

    static {
        log = LogFactory.getLog(MySQLConnector.class);
        serviceList = new ArrayList<String>();
        statusList = new ArrayList<String>();
    }
}

