/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.status.monitor.core.exception.StatusMonitorException;
import org.wso2.carbon.status.monitor.core.util.StatusMonitorUtil;
import org.wso2.carbon.status.monitor.internal.core.MySQLConnector;
import org.wso2.carbon.utils.ConfigurationContextService;

public class StatusMonitorServiceComponent {
    private static Log log = LogFactory.getLog(StatusMonitorServiceComponent.class);
    private static BundleContext bundleContext;
    private static ConfigurationContextService configurationContextService;

    protected void activate(ComponentContext context) {
        try {
            bundleContext = context.getBundleContext();
            if (StatusMonitorUtil.getStatusMonitorConfiguration() == null) {
                StatusMonitorUtil.initStatusMonitor((BundleContext)context.getBundleContext());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Status Monitor Agent initialized");
                }
            }
            this.initConnector();
            log.debug((Object)"******* Status Monitor bundle is activated ******* ");
        }
        catch (Exception e) {
            log.error((Object)"******* Status Monitor bundle failed activating ****", (Throwable)e);
        }
    }

    private void initConnector() throws StatusMonitorException {
        try {
            MySQLConnector.initialize();
        }
        catch (Exception e) {
            String msg = "Error in initializing the mysql connection for the health monitoring";
            log.error((Object)msg, (Throwable)e);
            throw new StatusMonitorException(msg, e);
        }
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Status Monitor bundle is deactivated ******* ");
    }

    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"Receiving ConfigurationContext Service");
        StatusMonitorServiceComponent.configurationContextService = configurationContextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"Unsetting ConfigurationContext Service");
        this.setConfigurationContextService(null);
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static ConfigurationContextService getConfigurationContextService() {
        return configurationContextService;
    }

    public static ConfigurationContext getConfigurationContext() {
        if (configurationContextService.getServerConfigContext() == null) {
            return null;
        }
        return configurationContextService.getServerConfigContext();
    }
}

