/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.ui.utils;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.status.monitor.stub.beans.xsd.ServiceStateDetailInfoBean;
import org.wso2.carbon.status.monitor.stub.beans.xsd.ServiceStateInfoBean;
import org.wso2.carbon.status.monitor.ui.clients.HealthMonitorServiceClient;

public class StatusMonitorUtil {
    private static final Log log = LogFactory.getLog(StatusMonitorUtil.class);

    public static ServiceStateInfoBean[] retrieveStatuses(HttpServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        try {
            HealthMonitorServiceClient serviceClient = new HealthMonitorServiceClient(config, session);
            return serviceClient.retrieveStatuses();
        }
        catch (Exception e) {
            String msg = "Failed to get the service status info beans";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public static ServiceStateDetailInfoBean[] retrieveStateDetails(HttpServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        try {
            HealthMonitorServiceClient serviceClient = new HealthMonitorServiceClient(config, session);
            return serviceClient.retrieveStateDetails();
        }
        catch (Exception e) {
            String msg = "Failed to get the service state details info beans";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public static ServiceStateInfoBean getStatus(HttpServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        String serviceName = "";
        try {
            serviceName = request.getParameter("service");
            HealthMonitorServiceClient serviceClient = new HealthMonitorServiceClient(config, session);
            return serviceClient.getServiceStatus(serviceName);
        }
        catch (Exception e) {
            String msg = "Failed to get the status details of the service:" + serviceName;
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }
}

