/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.status.monitor.stub.HealthMonitorServiceStub;
import org.wso2.carbon.status.monitor.stub.beans.xsd.ServiceStateDetailInfoBean;
import org.wso2.carbon.status.monitor.stub.beans.xsd.ServiceStateInfoBean;
import org.wso2.carbon.ui.CarbonUIUtil;

public class HealthMonitorServiceClient {
    private static final Log log = LogFactory.getLog(HealthMonitorServiceClient.class);
    private HealthMonitorServiceStub stub;

    public HealthMonitorServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        String epr = backendServerURL + "HealthMonitorService";
        try {
            this.stub = new HealthMonitorServiceStub(configContext, epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate HealthMonitor service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public HealthMonitorServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String epr = backendServerURL + "HealthMonitorService";
        try {
            this.stub = new HealthMonitorServiceStub(configContext, epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate HealthMonitor Services service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public ServiceStateInfoBean[] retrieveStatuses() throws Exception {
        return this.stub.getAllServiceStatus();
    }

    public ServiceStateInfoBean getServiceStatus(String serviceName) throws Exception {
        return this.stub.getServiceStatus(serviceName);
    }

    public ServiceStateDetailInfoBean[] retrieveStateDetails() throws Exception {
        return this.stub.getAllServiceStateDetail();
    }
}

