/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.agent.clients.service;

import java.sql.SQLException;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.status.monitor.agent.clients.common.ServiceLoginClient;
import org.wso2.carbon.status.monitor.agent.internal.core.MySQLConnector;
import org.wso2.carbon.status.monitor.core.StatusMonitorConfigurationBuilder;
import org.wso2.carbon.status.monitor.core.beans.AuthConfigBean;
import org.wso2.carbon.status.monitor.core.jdbc.MySQLConnectionInitializer;

public class MessageBrokerServiceClient
extends Thread {
    private static final Log log = LogFactory.getLog(MessageBrokerServiceClient.class);
    private static String tcpUserName;

    public void run() {
        block4: while (true) {
            try {
                while (true) {
                    MessageBrokerServiceClient.executeService();
                    if (this.isInterrupted()) break block4;
                    try {
                        MessageBrokerServiceClient.sleep(900000L);
                        continue block4;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
            catch (SQLException e) {
                log.error((Object)e);
                continue;
            }
            break;
        }
    }

    private static void executeService() throws SQLException {
        int serviceID = MySQLConnectionInitializer.getServiceID((String)"StratosLive Message Broker");
        AuthConfigBean authConfigBean = StatusMonitorConfigurationBuilder.getAuthConfigBean();
        String userName = authConfigBean.getUserName();
        tcpUserName = userName.replace('@', '!');
        if (ServiceLoginClient.loginChecker("messaging.stratoslive.wso2.com", serviceID)) {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", "org.apache.qpid.jndi.PropertiesFileInitialContextFactory");
            properties.put("connectionfactory.qpidConnectionfactory", MessageBrokerServiceClient.getTCPConnectionURL(tcpUserName, authConfigBean.getPassword()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("getTCPConnectionURL(username,password) = " + MessageBrokerServiceClient.getTCPConnectionURL(tcpUserName, authConfigBean.getPassword())));
            }
            try {
                InitialContext ctx = new InitialContext(properties);
                QueueConnectionFactory connFactory = (QueueConnectionFactory)ctx.lookup("qpidConnectionfactory");
                QueueConnection queueConnection = connFactory.createQueueConnection();
                queueConnection.start();
                QueueSession queueSession = queueConnection.createQueueSession(false, 1);
                Queue queue = queueSession.createQueue("testQueueQA6;{create:always, node:{durable: True}}");
                TextMessage textMessage = queueSession.createTextMessage("Test Message Hello");
                QueueSender queueSender = queueSession.createSender(queue);
                queueSender.setTimeToLive(100000000L);
                QueueReceiver queueReceiver = queueSession.createReceiver(queue);
                queueSender.send((Message)textMessage);
                TextMessage message = (TextMessage)queueReceiver.receiveNoWait();
                if (message.getText().equals("Test Message Hello")) {
                    MySQLConnector.insertStats(serviceID, true);
                    MySQLConnector.insertState(serviceID, true, "");
                } else {
                    MySQLConnector.insertStats(serviceID, false);
                    MySQLConnector.insertState(serviceID, false, "Send and retrieve messages failed");
                }
                queueSender.close();
                queueSession.close();
                queueConnection.close();
            }
            catch (JMSException e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                String msg = "Exception in executing the client - Status Monitor Agent for MessageBrokerServiceClient";
                log.warn((Object)msg, (Throwable)e);
            }
            catch (NamingException e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                String msg = "Naming exception in executing the client - Status Monitor agent for MessageBrokerServiceClient";
                log.warn((Object)msg, (Throwable)e);
            }
        }
    }

    private static String getTCPConnectionURL(String username, String password) {
        return new StringBuffer().append("amqp://").append(tcpUserName).append(":").append(password).append("@").append("carbon").append("/").append("carbon").append("?brokerlist='tcp://").append("messaging.stratoslive.wso2.com").append(":").append("5675").append("'").toString();
    }
}

