/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.agent.clients.service;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.status.monitor.agent.clients.common.ServiceLoginClient;
import org.wso2.carbon.status.monitor.agent.internal.core.MySQLConnector;
import org.wso2.carbon.status.monitor.core.StatusMonitorConfigurationBuilder;
import org.wso2.carbon.status.monitor.core.beans.AuthConfigBean;
import org.wso2.carbon.status.monitor.core.beans.SampleTenantConfigBean;
import org.wso2.carbon.status.monitor.core.jdbc.MySQLConnectionInitializer;

public class MashupServerClient
extends Thread {
    private static final Log log = LogFactory.getLog(MashupServerClient.class);
    private static final AuthConfigBean authConfigBean = StatusMonitorConfigurationBuilder.getAuthConfigBean();
    private static final SampleTenantConfigBean sampleTenantConfigBean = StatusMonitorConfigurationBuilder.getSampleTenantConfigBean();
    private static int serviceID;

    public void run() {
        block6: while (true) {
            try {
                while (true) {
                    MashupServerClient.executeService();
                    if (this.isInterrupted()) break block6;
                    try {
                        MashupServerClient.sleep(900000L);
                        continue block6;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                log.error((Object)e);
                continue;
            }
            catch (SQLException e) {
                log.error((Object)e);
                continue;
            }
            catch (ParseException e) {
                log.error((Object)e);
                continue;
            }
            break;
        }
    }

    private static OMElement createPayLoad() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://services.mashup.wso2.org/schemaTest1", "ns1");
        OMElement method = fac.createOMElement("echoJSString", omNs);
        OMElement value = fac.createOMElement("param", null);
        value.addChild((OMNode)fac.createOMText((OMContainer)value, "Hello World"));
        method.addChild((OMNode)value);
        return method;
    }

    private static void executeService() throws IOException, SQLException, ParseException {
        serviceID = MySQLConnectionInitializer.getServiceID((String)"StratosLive Mashup Server");
        OMElement payload = MashupServerClient.createPayLoad();
        ServiceClient serviceclient = new ServiceClient();
        Options opts = new Options();
        opts.setTo(new EndpointReference("http://mashup.stratoslive.wso2.com/services/t/" + authConfigBean.getTenant() + "/test123/schemaTest1/ "));
        opts.setAction("http://services.mashup.wso2.org/schemaTest1");
        if (ServiceLoginClient.loginChecker("mashup.stratoslive.wso2.com", serviceID)) {
            serviceclient.setOptions(opts);
            try {
                OMElement result = serviceclient.sendReceive(payload);
                if (result.toString().indexOf("Hello World") > 0) {
                    if (MashupServerClient.executeRelatedProductsService().booleanValue()) {
                        MySQLConnector.insertStats(serviceID, true);
                        MySQLConnector.insertState(serviceID, true, "");
                    }
                } else {
                    MySQLConnector.insertStats(serviceID, false);
                    MySQLConnector.insertState(serviceID, false, "Service Invocation failed");
                }
            }
            catch (AxisFault e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                String msg = "Error in executing the service - Status Monitor Agent for MashupServerClient";
                log.warn((Object)msg, (Throwable)e);
            }
            catch (NullPointerException e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                String msg = "NPE in executing the service - Status Monitor Agent for MashupServerClient";
                log.warn((Object)msg, (Throwable)e);
            }
            catch (XMLStreamException e) {
                String msg = "XMLStreamException in execting the service - Status Monitor Agent for MashupServerClient";
                log.warn((Object)msg, (Throwable)e);
            }
        }
    }

    private static Boolean executeRelatedProductsService() throws IOException, SQLException, ParseException, XMLStreamException {
        Boolean relatedProductsServiceStatus = false;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://services.mashup.wso2.org/RelatedProducts?xsd", "rel");
        OMElement payload = fac.createOMElement("getRelatedProducts", omNs);
        OMElement value1 = fac.createOMElement("query", null);
        OMElement value2 = fac.createOMElement("count", null);
        OMElement value3 = fac.createOMElement("format", null);
        value1.addChild((OMNode)fac.createOMText((OMContainer)value1, "mac"));
        value2.addChild((OMNode)fac.createOMText((OMContainer)value2, "2"));
        value3.addChild((OMNode)fac.createOMText((OMContainer)value3, "xml"));
        payload.addChild((OMNode)value1);
        payload.addChild((OMNode)value2);
        payload.addChild((OMNode)value3);
        ServiceClient serviceclient = new ServiceClient();
        Options opts = new Options();
        opts.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
        opts.setTo(new EndpointReference("http://mashup.stratoslive.wso2.com/services/t/" + sampleTenantConfigBean.getTenant() + "/carbon/RelatedProducts"));
        opts.setAction("http://services.mashup.wso2.org/RelatedProducts?xsd/RelatedProducts");
        serviceclient.setOptions(opts);
        try {
            OMElement result = serviceclient.sendReceive(payload);
            if (result.toString().contains("New USB Graphics Drawing Tablet Mouse Pad")) {
                relatedProductsServiceStatus = true;
            } else {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, "Platform Sample: RelatedProducts service Invocation failed");
            }
        }
        catch (AxisFault e) {
            MySQLConnector.insertStats(serviceID, false);
            MySQLConnector.insertState(serviceID, false, "Platform Sample: RelatedProducts - " + e.getMessage());
            String msg = "Error in executing the related products service";
            log.warn((Object)msg, (Throwable)e);
        }
        catch (NullPointerException e) {
            MySQLConnector.insertStats(serviceID, false);
            MySQLConnector.insertState(serviceID, false, "Platform Sample: RelatedProducts - " + e.getMessage());
            String msg = "NPE in executing the related products service";
            log.warn((Object)msg, (Throwable)e);
        }
        return relatedProductsServiceStatus;
    }
}

