/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.agent.clients.service;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.status.monitor.agent.internal.core.MySQLConnector;
import org.wso2.carbon.status.monitor.core.StatusMonitorConfigurationBuilder;
import org.wso2.carbon.status.monitor.core.beans.AuthConfigBean;
import org.wso2.carbon.status.monitor.core.jdbc.MySQLConnectionInitializer;

public class ManagerServiceClient
extends Thread {
    private static final Log log = LogFactory.getLog(ManagerServiceClient.class);
    private static final AuthConfigBean authConfigBean = StatusMonitorConfigurationBuilder.getAuthConfigBean();

    public void run() {
        block5: while (true) {
            try {
                while (true) {
                    ManagerServiceClient.executeService();
                    if (this.isInterrupted()) break block5;
                    try {
                        ManagerServiceClient.sleep(900000L);
                        continue block5;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                log.error((Object)e);
                continue;
            }
            catch (SQLException e) {
                log.error((Object)e);
                continue;
            }
            break;
        }
    }

    private static void executeService() throws SQLException, IOException {
        System.setProperty("javax.net.ssl.trustStore", authConfigBean.getJksLocation());
        System.setProperty("javax.net.ssl.trustStorePassword", "wso2carbon");
        System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        String userName = authConfigBean.getUserName();
        String password = authConfigBean.getPassword();
        int serviceID = MySQLConnectionInitializer.getServiceID((String)"StratosLive Manager");
        String authenticationServiceURL = "https://stratoslive.wso2.com/services/AuthenticationAdmin";
        try {
            AuthenticationAdminStub authenticationAdminStub = new AuthenticationAdminStub(authenticationServiceURL);
            ServiceClient client = authenticationAdminStub._getServiceClient();
            Options options = client.getOptions();
            options.setManageSession(true);
            Boolean status = authenticationAdminStub.login(userName, password, "stratoslive.wso2.com");
            ServiceContext serviceContext = authenticationAdminStub._getServiceClient().getLastOperationContext().getServiceContext();
            if (status.booleanValue()) {
                MySQLConnector.insertStats(serviceID, true);
                MySQLConnector.insertState(serviceID, true, "");
            }
        }
        catch (AxisFault e) {
            MySQLConnector.insertStats(serviceID, false);
            MySQLConnector.insertState(serviceID, false, e.getMessage());
            String msg = "Fault in executing the service - Status Monitor Agent for Manager";
            log.warn((Object)msg, (Throwable)e);
        }
        catch (Exception e) {
            MySQLConnector.insertStats(serviceID, false);
            MySQLConnector.insertState(serviceID, false, e.getMessage());
            String msg = "Exception in executing the service - Status Monitor Agent for Manager";
            log.warn((Object)msg, (Throwable)e);
        }
    }
}

