/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.agent.clients.service;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.app.RemoteRegistry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.status.monitor.agent.clients.common.ServiceLoginClient;
import org.wso2.carbon.status.monitor.agent.internal.core.MySQLConnector;
import org.wso2.carbon.status.monitor.core.StatusMonitorConfigurationBuilder;
import org.wso2.carbon.status.monitor.core.beans.AuthConfigBean;
import org.wso2.carbon.status.monitor.core.jdbc.MySQLConnectionInitializer;

public class GovernanceRegistryServerClient
extends Thread {
    private static final Log log = LogFactory.getLog(GovernanceRegistryServerClient.class);
    private static final AuthConfigBean authConfigBean = StatusMonitorConfigurationBuilder.getAuthConfigBean();
    static RemoteRegistry registry = null;

    public void run() {
        block6: while (true) {
            try {
                while (true) {
                    GovernanceRegistryServerClient.executeService();
                    if (this.isInterrupted()) break block6;
                    try {
                        GovernanceRegistryServerClient.sleep(900000L);
                        continue block6;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                log.error((Object)e);
                continue;
            }
            catch (SQLException e) {
                log.error((Object)e);
                continue;
            }
            catch (ParseException e) {
                log.error((Object)e);
                continue;
            }
            break;
        }
    }

    private static void executeService() throws IOException, SQLException, ParseException {
        boolean getValue = false;
        boolean putValue = false;
        boolean deleteValue = false;
        int serviceID = MySQLConnectionInitializer.getServiceID((String)"StratosLive Governance Registry");
        if (ServiceLoginClient.loginChecker("governance.stratoslive.wso2.com", serviceID)) {
            try {
                registry = new RemoteRegistry(new URL("http://governance.stratoslive.wso2.com/t/" + authConfigBean.getTenant() + "/registry"), authConfigBean.getUserName(), authConfigBean.getPassword());
            }
            catch (RegistryException e) {
                log.error((Object)e);
            }
            catch (MalformedURLException e) {
                log.error((Object)e);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            try {
                Resource r1 = registry.newResource();
                r1.setContent((Object)"test content".getBytes());
                r1.setMediaType("text/plain");
                String pathValue = registry.put("/_system/local/registry.txt", r1);
                if (pathValue.equalsIgnoreCase("/_system/local/registry.txt")) {
                    putValue = true;
                }
            }
            catch (RegistryException e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                log.warn((Object)e);
            }
            catch (Exception e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                log.warn((Object)e);
            }
            try {
                if (putValue) {
                    Resource r2 = registry.get("/_system/local/registry.txt");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Media Type: " + r2.getMediaType()));
                    }
                    if (r2.getMediaType().equalsIgnoreCase("text/plain")) {
                        getValue = true;
                    }
                }
            }
            catch (RegistryException e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                log.warn((Object)e);
            }
            catch (Exception e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                log.warn((Object)e);
            }
            try {
                if (getValue) {
                    registry.delete("/_system/local/registry.txt");
                    if (!registry.resourceExists("/_system/local/registry.txt")) {
                        deleteValue = true;
                    }
                }
            }
            catch (RegistryException e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                log.warn((Object)e);
            }
            catch (Exception e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                log.warn((Object)e);
            }
            try {
                if (getValue & putValue & deleteValue) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Governance Registry Status Monitor agent: Writing to the database");
                    }
                    MySQLConnector.insertStats(serviceID, true);
                    MySQLConnector.insertState(serviceID, true, "");
                }
            }
            catch (SQLException e) {
                String msg = "Error in writing to the database for Governance Registry - status monitor agent";
                log.error((Object)msg, (Throwable)e);
            }
        }
    }
}

