/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.agent.clients.service;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.status.monitor.agent.clients.common.ServiceLoginClient;
import org.wso2.carbon.status.monitor.agent.internal.core.MySQLConnector;
import org.wso2.carbon.status.monitor.core.StatusMonitorConfigurationBuilder;
import org.wso2.carbon.status.monitor.core.beans.AuthConfigBean;
import org.wso2.carbon.status.monitor.core.jdbc.MySQLConnectionInitializer;

public class BPSServerClient
extends Thread {
    private static final Log log = LogFactory.getLog(BPSServerClient.class);
    private static final AuthConfigBean authConfigBean = StatusMonitorConfigurationBuilder.getAuthConfigBean();

    public void run() {
        block6: while (true) {
            try {
                while (true) {
                    BPSServerClient.executeService();
                    if (this.isInterrupted()) break block6;
                    try {
                        BPSServerClient.sleep(900000L);
                        continue block6;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                log.error((Object)e);
                continue;
            }
            catch (SQLException e) {
                log.error((Object)e);
                continue;
            }
            catch (ParseException e) {
                log.error((Object)e);
                continue;
            }
            break;
        }
    }

    private static OMElement createPayLoad() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://ode/bpel/unit-test.wsdl", "ns1");
        OMElement method = fac.createOMElement("hello", omNs);
        OMElement value = fac.createOMElement("TestPart", null);
        value.addChild((OMNode)fac.createOMText((OMContainer)value, "Hello"));
        method.addChild((OMNode)value);
        return method;
    }

    private static void executeService() throws IOException, SQLException, ParseException {
        int serviceID = MySQLConnectionInitializer.getServiceID((String)"StratosLive Business Process Server");
        OMElement payload = BPSServerClient.createPayLoad();
        ServiceClient serviceclient = new ServiceClient();
        Options opts = new Options();
        opts.setTo(new EndpointReference("http://process.stratoslive.wso2.com/services/t/" + authConfigBean.getTenant() + "/HelloService"));
        opts.setAction("http://ode/bpel/unit-test.wsdl/hello");
        if (ServiceLoginClient.loginChecker("process.stratoslive.wso2.com", serviceID)) {
            serviceclient.setOptions(opts);
            try {
                OMElement result = serviceclient.sendReceive(payload);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Result of BPS: " + result));
                }
                if (result.toString().indexOf("Hello World") > 0) {
                    MySQLConnector.insertStats(serviceID, true);
                    MySQLConnector.insertState(serviceID, true, "");
                } else {
                    MySQLConnector.insertStats(serviceID, false);
                    MySQLConnector.insertState(serviceID, false, "Service Invocation failed");
                }
            }
            catch (AxisFault e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                log.warn((Object)e);
            }
            catch (NullPointerException e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                log.warn((Object)e);
            }
        }
    }
}

