/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.agent.clients.common;

import java.sql.SQLException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.status.monitor.agent.internal.core.MySQLConnector;
import org.wso2.carbon.status.monitor.core.StatusMonitorConfigurationBuilder;
import org.wso2.carbon.status.monitor.core.beans.AuthConfigBean;

public class ServiceLoginClient {
    private static final Log log = LogFactory.getLog(ServiceLoginClient.class);
    private static AuthConfigBean authConfigBean = StatusMonitorConfigurationBuilder.getAuthConfigBean();

    public static boolean loginChecker(String hostName, int serviceID) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("************** TRUST STORE : " + System.getProperty("javax.net.ssl.trustStore")));
        }
        String userName = authConfigBean.getUserName();
        String password = authConfigBean.getPassword();
        boolean loginStatus = false;
        String authenticationServiceURL = "https://" + hostName + "/services/AuthenticationAdmin";
        try {
            AuthenticationAdminStub authenticationAdminStub = new AuthenticationAdminStub(authenticationServiceURL);
            ServiceClient client = authenticationAdminStub._getServiceClient();
            Options options = client.getOptions();
            options.setManageSession(true);
            loginStatus = authenticationAdminStub.login(userName, password, hostName);
            ServiceContext serviceContext = authenticationAdminStub._getServiceClient().getLastOperationContext().getServiceContext();
            String msg = "Log in client successfully logged in to the service: " + hostName;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg);
            }
            if (!loginStatus) {
                msg = "Login Checker failed for the service: " + hostName;
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, msg);
                log.warn((Object)msg);
            }
        }
        catch (AxisFault e) {
            MySQLConnector.insertStats(serviceID, false);
            MySQLConnector.insertState(serviceID, false, e.getMessage());
            String msg = "Failed to login; Inserting the stats in the db for the log in checker";
            log.warn((Object)msg, (Throwable)e);
        }
        catch (Exception e) {
            MySQLConnector.insertStats(serviceID, false);
            MySQLConnector.insertState(serviceID, false, e.getMessage());
            String msg = "Exception in login; Inserting the stats in the db for the log in checker";
            log.warn((Object)msg, (Throwable)e);
        }
        return loginStatus;
    }

    static {
        System.setProperty("javax.net.ssl.trustStore", authConfigBean.getJksLocation());
        System.setProperty("javax.net.ssl.trustStorePassword", "wso2carbon");
        System.setProperty("javax.net.ssl.trustStoreType", "JKS");
    }
}

