/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.core.util;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.status.monitor.core.StatusMonitorConfigurationBuilder;
import org.wso2.carbon.status.monitor.core.exception.StatusMonitorException;
import org.wso2.carbon.status.monitor.core.jdbc.MySQLConnectionInitializer;
import org.wso2.carbon.utils.CarbonUtils;

public class StatusMonitorUtil {
    private static final Log log = LogFactory.getLog(StatusMonitorUtil.class);
    private static StatusMonitorConfigurationBuilder statusMonitorConfiguration;

    public static StatusMonitorConfigurationBuilder getStatusMonitorConfiguration() {
        return statusMonitorConfiguration;
    }

    public static void initStatusMonitor(BundleContext bundleContext) throws StatusMonitorException {
        String configFile = CarbonUtils.getCarbonConfigDirPath() + File.separator + "status-monitor-config.xml";
        try {
            statusMonitorConfiguration = new StatusMonitorConfigurationBuilder(configFile);
        }
        catch (Exception e) {
            String msg = "The Status Monitor Configuration file not found";
            log.error((Object)msg, (Throwable)e);
            throw new StatusMonitorException(msg, e);
        }
        try {
            MySQLConnectionInitializer.initialize();
        }
        catch (Exception e) {
            String msg = "Error in initializing the mysql connection for the health monitoring";
            log.error((Object)msg, (Throwable)e);
            throw new StatusMonitorException(msg, e);
        }
    }
}

