/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.core.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.status.monitor.core.StatusMonitorConfigurationBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLConnectionInitializer {
    private static Connection conn = null;
    private static BasicDataSource dataSource;
    private static final Log log;
    private static List<String> serviceList;
    private static List<String> statusList;

    public static List<String> getServiceList() {
        return Collections.unmodifiableList(serviceList);
    }

    public static List<String> getStatusList() {
        return Collections.unmodifiableList(statusList);
    }

    public static Connection initialize() throws Exception {
        dataSource = StatusMonitorConfigurationBuilder.getDataSource();
        MySQLConnectionInitializer.getConnection();
        serviceList = MySQLConnectionInitializer.getServiceNamesList();
        statusList = MySQLConnectionInitializer.getStateNameList();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully initialized the mysql connection");
        }
        return conn;
    }

    private static Connection getConnection() throws Exception {
        try {
            String userName = dataSource.getUsername();
            String password = dataSource.getPassword();
            String url = dataSource.getUrl();
            String driverName = dataSource.getDriverClassName();
            Class.forName(driverName).newInstance();
            conn = DriverManager.getConnection(url, userName, password);
            if (conn != null && log.isDebugEnabled()) {
                log.debug((Object)"Connection Successful");
            }
        }
        catch (SQLException e) {
            String msg = "SQL connection to the health monitor database instance failed";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        catch (Exception e) {
            String msg = "Connection to the health monitor database instance failed";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return conn;
    }

    private static List<String> getServiceNamesList() throws SQLException {
        ArrayList<String> serviceList = new ArrayList<String>();
        Statement stmtCon = conn.createStatement();
        String sql = "SELECT WSL_NAME FROM WSL_SERVICE";
        stmtCon.executeQuery(sql);
        ResultSet rs = stmtCon.getResultSet();
        try {
            while (rs.next()) {
                String serviceName = rs.getString("WSL_NAME");
                serviceList.add(serviceName);
            }
        }
        catch (SQLException e) {
            String msg = "Getting the service name list failed";
            log.error((Object)msg, (Throwable)e);
            throw new SQLException(msg, e);
        }
        finally {
            rs.close();
            stmtCon.close();
        }
        return serviceList;
    }

    private static List<String> getStateNameList() throws SQLException {
        ArrayList<String> stateList = new ArrayList<String>();
        Statement stmtCon = conn.createStatement();
        String sql = "SELECT WSL_NAME FROM WSL_STATE";
        stmtCon.executeQuery(sql);
        ResultSet rs = stmtCon.getResultSet();
        try {
            while (rs.next()) {
                String stateName = rs.getString("WSL_NAME");
                stateList.add(stateName);
            }
        }
        catch (SQLException e) {
            String msg = "Getting the serviceID failed";
            log.error((Object)msg, (Throwable)e);
            throw new SQLException(msg, e);
        }
        finally {
            rs.close();
            stmtCon.close();
        }
        return stateList;
    }

    public static int getServiceID(String product) throws SQLException {
        Statement stmtCon = conn.createStatement();
        String sql = "SELECT WSL_ID FROM WSL_SERVICE WHERE WSL_NAME LIKE \"" + product + "\"";
        int serviceId = 0;
        ResultSet rs = stmtCon.getResultSet();
        try {
            stmtCon.executeQuery(sql);
            while (rs.next()) {
                serviceId = rs.getInt("WSL_ID");
            }
        }
        catch (SQLException e) {
            String msg = "Getting the serviceID failed";
            log.error((Object)msg, (Throwable)e);
            throw new SQLException(msg, e);
        }
        finally {
            rs.close();
            stmtCon.close();
        }
        return serviceId;
    }

    public static int getServiceStateID(int serviceID) throws SQLException {
        Statement stmtCon = conn.createStatement();
        String sql = "SELECT WSL_ID FROM WSL_SERVICE_STATE WHERE WSL_SERVICE_ID = " + serviceID + " ORDER BY WSL_TIMESTAMP DESC LIMIT 1";
        stmtCon.executeQuery(sql);
        ResultSet rs = stmtCon.getResultSet();
        int stateID = 0;
        try {
            while (rs.next()) {
                stateID = rs.getInt("WSL_ID");
            }
        }
        catch (SQLException e) {
            String msg = "Getting the service state ID failed";
            log.error((Object)msg, (Throwable)e);
            throw new SQLException(msg, e);
        }
        finally {
            rs.close();
            stmtCon.close();
        }
        return stateID;
    }

    static {
        log = LogFactory.getLog(StatusMonitorConfigurationBuilder.class);
        serviceList = new ArrayList<String>();
        statusList = new ArrayList<String>();
    }
}

