/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.core.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.status.monitor.core.util.StatusMonitorUtil;
import org.wso2.carbon.utils.ConfigurationContextService;

public class StatusMonitorCoreComponent {
    private static Log log = LogFactory.getLog(StatusMonitorCoreComponent.class);
    private static BundleContext bundleContext;
    private static ConfigurationContextService configurationContextService;

    protected void activate(ComponentContext context) {
        try {
            bundleContext = context.getBundleContext();
            if (StatusMonitorUtil.getStatusMonitorConfiguration() == null) {
                StatusMonitorUtil.initStatusMonitor(context.getBundleContext());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Status Monitor Agent initialized");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"******* Status Monitor core bundle is activated ******* ");
            }
        }
        catch (Exception e) {
            log.error((Object)"******* Status Monitor Core bundle failed activating ****", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Status Monitor core bundle is deactivated ******* ");
    }

    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"Receiving ConfigurationContext Service");
        StatusMonitorCoreComponent.configurationContextService = configurationContextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"Unsetting ConfigurationContext Service");
        this.setConfigurationContextService(null);
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static ConfigurationContextService getConfigurationContextService() {
        return configurationContextService;
    }

    public static ConfigurationContext getConfigurationContext() {
        if (configurationContextService.getServerConfigContext() == null) {
            return null;
        }
        return configurationContextService.getServerConfigContext();
    }
}

