/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.core;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.status.monitor.core.beans.AuthConfigBean;
import org.wso2.carbon.status.monitor.core.beans.SampleTenantConfigBean;
import org.wso2.carbon.status.monitor.core.exception.StatusMonitorException;

public class StatusMonitorConfigurationBuilder {
    private static final Log log = LogFactory.getLog(StatusMonitorConfigurationBuilder.class);
    private static BasicDataSource dataSource;
    private static AuthConfigBean authConfigBean;
    private static SampleTenantConfigBean sampleTenantConfigBean;

    public StatusMonitorConfigurationBuilder(String statusConfigFile) throws StatusMonitorException {
        try {
            OMElement statusConfig = this.buildOMElement(new FileInputStream(statusConfigFile));
            this.deserialize(statusConfig);
            if (log.isDebugEnabled()) {
                log.debug((Object)("********Status Monitor Configuration Builder**********" + statusConfigFile));
            }
        }
        catch (FileNotFoundException e) {
            String msg = "Unable to find the file responsible for status monitor configs: " + statusConfigFile;
            log.error((Object)msg, (Throwable)e);
            throw new StatusMonitorException(msg, e);
        }
    }

    private OMElement buildOMElement(InputStream inputStream) throws StatusMonitorException {
        XMLStreamReader parser;
        try {
            parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
        }
        catch (XMLStreamException e) {
            String msg = "Error in initializing the parser to build the OMElement.";
            log.error((Object)msg, (Throwable)e);
            throw new StatusMonitorException(msg, e);
        }
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        return builder.getDocumentElement();
    }

    private void deserialize(OMElement statusMonitorConfigEle) throws StatusMonitorException {
        Iterator statusMonitorConfigChildIt = statusMonitorConfigEle.getChildElements();
        while (statusMonitorConfigChildIt.hasNext()) {
            OMElement statusMonitorConfigChildEle = (OMElement)statusMonitorConfigChildIt.next();
            if (new QName("http://wso2.com/carbon/status/monitor/config", "dbConfig", "").equals(statusMonitorConfigChildEle.getQName())) {
                this.initDataSource(statusMonitorConfigChildEle);
                continue;
            }
            if (new QName("http://wso2.com/carbon/status/monitor/config", "authConfig", "").equals(statusMonitorConfigChildEle.getQName())) {
                this.initAuthentication(statusMonitorConfigChildEle);
                continue;
            }
            if (new QName("http://wso2.com/carbon/status/monitor/config", "platformSample", "").equals(statusMonitorConfigChildEle.getQName())) {
                this.initSampleServicesMonitoring(statusMonitorConfigChildEle);
                continue;
            }
            String msg = "Unknown element in Status Monitor Configuration: " + statusMonitorConfigChildEle.getQName().getLocalPart();
            log.warn((Object)msg);
        }
    }

    private void initDataSource(OMElement dbConfigEle) throws StatusMonitorException {
        Iterator dbConfigChildIt = dbConfigEle.getChildElements();
        dataSource = new BasicDataSource();
        while (dbConfigChildIt.hasNext()) {
            OMElement dbConfigChildEle = (OMElement)dbConfigChildIt.next();
            if (new QName("http://wso2.com/carbon/status/monitor/config", "url", "").equals(dbConfigChildEle.getQName())) {
                dataSource.setUrl(dbConfigChildEle.getText());
                continue;
            }
            if (new QName("http://wso2.com/carbon/status/monitor/config", "userName", "").equals(dbConfigChildEle.getQName())) {
                dataSource.setUsername(dbConfigChildEle.getText());
                continue;
            }
            if (new QName("http://wso2.com/carbon/status/monitor/config", "password", "").equals(dbConfigChildEle.getQName())) {
                dataSource.setPassword(dbConfigChildEle.getText());
                continue;
            }
            if (new QName("http://wso2.com/carbon/status/monitor/config", "driverName", "").equals(dbConfigChildEle.getQName())) {
                dataSource.setDriverClassName(dbConfigChildEle.getText());
                continue;
            }
            if (new QName("http://wso2.com/carbon/status/monitor/config", "maxActive", "").equals(dbConfigChildEle.getQName())) {
                dataSource.setMaxActive(Integer.parseInt(dbConfigChildEle.getText()));
                continue;
            }
            if (new QName("http://wso2.com/carbon/status/monitor/config", "maxWait", "").equals(dbConfigChildEle.getQName())) {
                dataSource.setMaxWait((long)Integer.parseInt(dbConfigChildEle.getText()));
                continue;
            }
            if (new QName("http://wso2.com/carbon/status/monitor/config", "minIdle", "").equals(dbConfigChildEle.getQName())) {
                dataSource.setMinIdle(Integer.parseInt(dbConfigChildEle.getText()));
                continue;
            }
            if (new QName("http://wso2.com/carbon/status/monitor/config", "validationQuery", "").equals(dbConfigChildEle.getQName())) {
                dataSource.setValidationQuery(dbConfigChildEle.getText());
                continue;
            }
            String msg = "Unknown element in DBConfig of Status Monitor Configuration: " + dbConfigChildEle.getQName().getLocalPart();
            log.warn((Object)msg);
        }
    }

    private void initAuthentication(OMElement authConfigEle) throws StatusMonitorException {
        Iterator authConfigChildIt = authConfigEle.getChildElements();
        authConfigBean = new AuthConfigBean();
        while (authConfigChildIt.hasNext()) {
            OMElement authConfigChildEle = (OMElement)authConfigChildIt.next();
            if (new QName("http://wso2.com/carbon/status/monitor/config", "jksLocation", "").equals(authConfigChildEle.getQName())) {
                authConfigBean.setJksLocation(authConfigChildEle.getText());
                continue;
            }
            if (new QName("http://wso2.com/carbon/status/monitor/config", "userName", "").equals(authConfigChildEle.getQName())) {
                authConfigBean.setUserName(authConfigChildEle.getText());
                continue;
            }
            if (new QName("http://wso2.com/carbon/status/monitor/config", "password", "").equals(authConfigChildEle.getQName())) {
                authConfigBean.setPassword(authConfigChildEle.getText());
                continue;
            }
            if (new QName("http://wso2.com/carbon/status/monitor/config", "tenantDomain", "").equals(authConfigChildEle.getQName())) {
                authConfigBean.setTenant(authConfigChildEle.getText());
                continue;
            }
            String msg = "Unknown element in AuthConfig of Status Monitor Configuration: " + authConfigChildEle.getQName().getLocalPart();
            log.warn((Object)msg);
        }
    }

    private void initSampleServicesMonitoring(OMElement psConfigEle) throws StatusMonitorException {
        Iterator psConfigChildIt = psConfigEle.getChildElements();
        sampleTenantConfigBean = new SampleTenantConfigBean();
        while (psConfigChildIt.hasNext()) {
            OMElement psConfigChildEle = (OMElement)psConfigChildIt.next();
            if (new QName("http://wso2.com/carbon/status/monitor/config", "tenantDomain", "").equals(psConfigChildEle.getQName())) {
                sampleTenantConfigBean.setTenant(psConfigChildEle.getText());
                continue;
            }
            String msg = "Unknown element in PSConfig of Status Monitor Configuration: " + psConfigChildEle.getQName().getLocalPart();
            log.warn((Object)msg);
        }
    }

    public static BasicDataSource getDataSource() {
        return dataSource;
    }

    public static AuthConfigBean getAuthConfigBean() {
        return authConfigBean;
    }

    public static SampleTenantConfigBean getSampleTenantConfigBean() {
        return sampleTenantConfigBean;
    }
}

