/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.agent.internal.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.status.monitor.core.jdbc.MySQLConnectionInitializer;

public class MySQLConnector {
    private static Connection conn;
    private static final Log log;
    private static List<String> serviceList;
    private static List<String> statusList;
    private static int resolvedNotFixed;
    private static int resolvedWSLID;

    public static Connection initialize() throws Exception {
        conn = MySQLConnectionInitializer.initialize();
        serviceList = MySQLConnectionInitializer.getServiceList();
        statusList = MySQLConnectionInitializer.getStatusList();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Connection to the status database is initialized from status.monitor");
        }
        return conn;
    }

    public static void insertStats(int serviceID, Boolean status) throws SQLException {
        String sql = "INSERT INTO WSL_SERVICE_HEARTBEAT VALUES (?,?,?,?)";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        try {
            pstmt.setString(1, null);
            pstmt.setInt(2, serviceID);
            pstmt.setBoolean(3, status);
            pstmt.setString(4, null);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            String msg = "Inserting stats failed";
            log.error((Object)msg, (Throwable)e);
            throw new SQLException(msg, e);
        }
        finally {
            pstmt.close();
        }
    }

    public static void insertState(int serviceID, Boolean status, String details) throws SQLException {
        String sql;
        int stateID = MySQLConnectionInitializer.getServiceStateID((int)serviceID);
        if (!status.booleanValue()) {
            MySQLConnector.insertStateDetails(stateID, status, details);
        }
        if (resolvedNotFixed == 0 || resolvedNotFixed == 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Inserting data into the state database");
            }
            sql = "INSERT INTO WSL_SERVICE_STATE VALUES (?,?,?,?)";
            PreparedStatement pstmt = conn.prepareStatement(sql);
            try {
                pstmt.setString(1, null);
                pstmt.setInt(2, serviceID);
                if (status.booleanValue()) {
                    pstmt.setInt(3, 1);
                } else {
                    pstmt.setInt(3, 2);
                }
                pstmt.setString(4, null);
                pstmt.executeUpdate();
            }
            catch (SQLException e) {
                String msg = "Inserting state failed";
                log.error((Object)msg, (Throwable)e);
                throw new SQLException(msg, e);
            }
            finally {
                resolvedWSLID = 0;
                resolvedNotFixed = 0;
                pstmt.close();
            }
        }
        if (resolvedNotFixed == 2) {
            sql = "UPDATE WSL_SERVICE_STATE SET WSL_STATE_ID=? WHERE WSL_ID= ?";
            PreparedStatement pstmtUpdate = conn.prepareStatement(sql);
            try {
                if (status.booleanValue()) {
                    pstmtUpdate.setInt(1, 1);
                } else {
                    pstmtUpdate.setInt(1, 2);
                }
                pstmtUpdate.setInt(2, resolvedWSLID);
                pstmtUpdate.executeUpdate();
            }
            catch (SQLException e) {
                String msg = "Inserting state failed";
                log.error((Object)msg, (Throwable)e);
                throw new SQLException(msg, e);
            }
            finally {
                resolvedNotFixed = 0;
                resolvedWSLID = 0;
                pstmtUpdate.close();
            }
        }
    }

    public static void insertStateDetails(int serviceStateID, boolean status, String detail) throws SQLException {
        String sql = "INSERT INTO WSL_SERVICE_STATE_DETAIL VALUES (?,?,?,?)";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        try {
            pstmt.setString(1, null);
            pstmt.setInt(2, serviceStateID);
            if (!status) {
                pstmt.setString(3, detail);
            }
            pstmt.setString(4, null);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            String msg = "Inserting state details failed";
            log.error((Object)msg, (Throwable)e);
            throw new SQLException(msg, e);
        }
        finally {
            pstmt.close();
        }
    }

    public static boolean getInsertStatus(int ServiceID) throws SQLException {
        ResultSet rs = null;
        Statement stmtCon = null;
        boolean currentStatus = false;
        String sqlGetStateID = "SELECT * FROM  WSL_SERVICE_STATE WHERE WSL_SERVICE_ID =" + ServiceID + " ORDER BY WSL_TIMESTAMP DESC LIMIT 0,1";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date SystemDate = new Date();
        dateFormat.format(SystemDate);
        try {
            stmtCon = conn.createStatement();
            stmtCon.executeQuery(sqlGetStateID);
            rs = stmtCon.getResultSet();
            if (rs != null) {
                while (rs.next()) {
                    int state_id = rs.getInt("WSL_STATE_ID");
                    if (state_id == 1) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Up and Running :" + state_id));
                        }
                        currentStatus = true;
                    }
                    if (state_id == 2) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Broken :" + state_id));
                        }
                        currentStatus = true;
                    }
                    if (state_id != 4) continue;
                    currentStatus = true;
                    Timestamp date = rs.getTimestamp("WSL_TIMESTAMP");
                    resolvedWSLID = rs.getInt("WSL_ID");
                    long currentTimeMs = SystemDate.getTime();
                    long resolvedTimeMs = ((Date)date).getTime();
                    double time_diff = (double)(currentTimeMs - resolvedTimeMs) / 3600000.0;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("State ID: " + state_id));
                    }
                    if (time_diff >= 1.0) {
                        resolvedNotFixed = 1;
                        continue;
                    }
                    resolvedNotFixed = 2;
                }
            } else {
                currentStatus = true;
            }
        }
        catch (SQLException e) {
            String msg = "Getting Insert state failed";
            log.error((Object)msg, (Throwable)e);
            throw new SQLException(msg, e);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmtCon != null) {
                stmtCon.close();
            }
        }
        return currentStatus;
    }

    static {
        log = LogFactory.getLog(MySQLConnector.class);
        serviceList = new ArrayList<String>();
        statusList = new ArrayList<String>();
        resolvedNotFixed = 0;
    }
}

