/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.agent.clients.service;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.app.RemoteRegistry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.status.monitor.agent.clients.common.ServiceLoginClient;
import org.wso2.carbon.status.monitor.agent.internal.core.MySQLConnector;
import org.wso2.carbon.status.monitor.core.StatusMonitorConfigurationBuilder;
import org.wso2.carbon.status.monitor.core.beans.AuthConfigBean;
import org.wso2.carbon.status.monitor.core.jdbc.MySQLConnectionInitializer;

public class GadgetServerClient
extends Thread {
    private static final Log log = LogFactory.getLog(GadgetServerClient.class);
    private static final AuthConfigBean authConfigBean = StatusMonitorConfigurationBuilder.getAuthConfigBean();
    static RemoteRegistry registry = null;

    public void run() {
        block6: while (true) {
            try {
                while (true) {
                    GadgetServerClient.executeService();
                    if (this.isInterrupted()) break block6;
                    try {
                        GadgetServerClient.sleep(900000L);
                        continue block6;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                log.error((Object)e);
                continue;
            }
            catch (SQLException e) {
                log.error((Object)e);
                continue;
            }
            catch (ParseException e) {
                log.error((Object)e);
                continue;
            }
            break;
        }
    }

    private static void executeService() throws IOException, SQLException, ParseException {
        int serviceID = MySQLConnectionInitializer.getServiceID((String)"StratosLive Gadget Server");
        if (ServiceLoginClient.loginChecker("gadget.stratoslive.wso2.com", serviceID)) {
            try {
                registry = new RemoteRegistry(new URL("http://gadget.stratoslive.wso2.com/t/" + authConfigBean.getTenant() + "/registry"), authConfigBean.getUserName(), authConfigBean.getPassword());
            }
            catch (RegistryException e) {
                log.error((Object)e);
            }
            catch (MalformedURLException e) {
                log.error((Object)e);
            }
            try {
                Resource r2 = registry.get("/_system/config/repository/gadget-server/gadgets/AmazonSearchGadget/amazon-search.xml");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("MediaType in the executeService() of GadgetServerClient in Status Monitor Agent: " + r2.getMediaType()));
                }
                if (r2.getMediaType().equalsIgnoreCase("application/vnd.wso2-gadget+xml")) {
                    MySQLConnector.insertStats(serviceID, true);
                    MySQLConnector.insertState(serviceID, true, "");
                }
            }
            catch (RegistryException e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                String msg = "Exception in executing the service for GadgetServerClient - Status Monitor Agent";
                log.error((Object)msg, (Throwable)e);
            }
        }
    }
}

