/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.agent.clients.service;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.status.monitor.agent.clients.common.ServiceLoginClient;
import org.wso2.carbon.status.monitor.agent.internal.core.MySQLConnector;
import org.wso2.carbon.status.monitor.core.StatusMonitorConfigurationBuilder;
import org.wso2.carbon.status.monitor.core.beans.AuthConfigBean;
import org.wso2.carbon.status.monitor.core.beans.SampleTenantConfigBean;
import org.wso2.carbon.status.monitor.core.jdbc.MySQLConnectionInitializer;

public class ESBServerClient
extends Thread {
    private static final Log log = LogFactory.getLog(ESBServerClient.class);
    private static final AuthConfigBean authConfigBean = StatusMonitorConfigurationBuilder.getAuthConfigBean();
    private static final SampleTenantConfigBean sampleTenantConfigBean = StatusMonitorConfigurationBuilder.getSampleTenantConfigBean();
    private static int serviceID;

    public void run() {
        block6: while (true) {
            try {
                while (true) {
                    ESBServerClient.executeService();
                    if (this.isInterrupted()) break block6;
                    try {
                        ESBServerClient.sleep(900000L);
                        continue block6;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                log.error((Object)e);
                continue;
            }
            catch (SQLException e) {
                log.error((Object)e);
                continue;
            }
            catch (ParseException e) {
                log.error((Object)e);
                continue;
            }
            break;
        }
    }

    private static OMElement createPayLoad() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://service.carbon.wso2.org", "ns1");
        OMElement method = fac.createOMElement("echoString", omNs);
        OMElement value = fac.createOMElement("s", omNs);
        value.addChild((OMNode)fac.createOMText((OMContainer)value, "Hello World"));
        method.addChild((OMNode)value);
        return method;
    }

    private static void executeService() throws IOException, SQLException, ParseException {
        OMElement result = null;
        OMElement payload = ESBServerClient.createPayLoad();
        ServiceClient serviceclient = new ServiceClient();
        Options opts = new Options();
        opts.setTo(new EndpointReference("http://esb.stratoslive.wso2.com:8280/services/t/" + authConfigBean.getTenant() + "/DemoProxy"));
        opts.setAction("http://service.carbon.wso2.org/echoString");
        serviceID = MySQLConnectionInitializer.getServiceID((String)"StratosLive Enterprise Service Bus");
        if (ServiceLoginClient.loginChecker("esb.stratoslive.wso2.com", serviceID)) {
            serviceclient.setOptions(opts);
            try {
                result = serviceclient.sendReceive(payload);
                if (result.toString().indexOf("Hello World") > 0) {
                    ESBServerClient.executeProductPlatformSample();
                } else {
                    MySQLConnector.insertStats(serviceID, false);
                    MySQLConnector.insertState(serviceID, false, "Service Invocation failed");
                }
            }
            catch (AxisFault e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                String msg = "Error in executing service";
                log.error((Object)msg, (Throwable)e);
            }
            catch (NullPointerException e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                String msg = "NPE in executing the service";
                log.error((Object)msg, (Throwable)e);
            }
        }
    }

    private static boolean executeProductPlatformSample() throws IOException, SQLException, ParseException {
        Boolean sampleStatus = false;
        String payload = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">\n   <soapenv:Header/>\n   <soapenv:Body/>\n</soapenv:Envelope>";
        String action = "getAllCategories";
        try {
            OMElement result = null;
            result = ESBServerClient.sendRequest(payload, action, new EndpointReference("http://esb.stratoslive.wso2.com:8280/services/t/" + sampleTenantConfigBean.getTenant() + "/ProductService"));
            if (result.toString().indexOf("Compact Lens-Shutter Cameras") > 0) {
                ESBServerClient.executeAdminServicePlatformSample();
                sampleStatus = true;
            } else {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, "Platform sample ProductService invocation failed");
            }
        }
        catch (AxisFault e) {
            MySQLConnector.insertStats(serviceID, false);
            MySQLConnector.insertState(serviceID, false, "Platform sample: " + e.getMessage());
            String msg = "Error in executing the product platform sample";
            log.error((Object)msg, (Throwable)e);
        }
        catch (NullPointerException e) {
            MySQLConnector.insertStats(serviceID, false);
            MySQLConnector.insertState(serviceID, false, "Platform sample: " + e.getMessage());
            String msg = "NPE in executing the product platform sample";
            log.error((Object)msg, (Throwable)e);
        }
        catch (XMLStreamException e) {
            String msg = "XMLStream exception in executing the product platform sample";
            log.error((Object)msg, (Throwable)e);
        }
        return sampleStatus;
    }

    private static boolean executeAdminServicePlatformSample() throws IOException, SQLException, ParseException {
        Boolean sampleStatus = false;
        int serviceID = MySQLConnectionInitializer.getServiceID((String)"StratosLive Enterprise Service Bus");
        String payload = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">\n   <soapenv:Header/>\n   <soapenv:Body/>\n</soapenv:Envelope>";
        String action = "getAllCategories";
        try {
            OMElement result = ESBServerClient.sendRequest(payload, action, new EndpointReference("http://esb.stratoslive.wso2.com:8280/services/t/" + sampleTenantConfigBean.getTenant() + "/AdminService"));
            if (result.toString().indexOf("Compact Lens-Shutter Cameras") > 0) {
                sampleStatus = true;
                MySQLConnector.insertStats(serviceID, true);
                MySQLConnector.insertState(serviceID, true, "");
            } else {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, "Platform sample AdminService invocation failed");
            }
        }
        catch (AxisFault e) {
            MySQLConnector.insertStats(serviceID, false);
            MySQLConnector.insertState(serviceID, false, "Platform sample AdminService: " + e.getMessage());
            String msg = "Executing Admin Service Platform Sample failed";
            log.error((Object)msg, (Throwable)e);
        }
        catch (NullPointerException e) {
            MySQLConnector.insertStats(serviceID, false);
            MySQLConnector.insertState(serviceID, false, "Platform sample AdminService: " + e.getMessage());
            String msg = "NPE in executing the admin service platform sample";
            log.error((Object)msg, (Throwable)e);
        }
        catch (XMLStreamException e) {
            String msg = "XMLStreamException in executing the admin service platform sample";
            log.error((Object)msg, (Throwable)e);
        }
        return sampleStatus;
    }

    private static OMElement sendRequest(String payloadStr, String action, EndpointReference targetEPR) throws XMLStreamException, AxisFault {
        OMElement payload = AXIOMUtil.stringToOM((String)payloadStr);
        Options options = new Options();
        options.setTo(targetEPR);
        options.setAction("urn:" + action);
        ServiceClient sender = new ServiceClient();
        sender.setOptions(options);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request: " + payload.toString()));
        }
        OMElement result = sender.sendReceive(payload);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Response:" + payload.toString()));
        }
        return result;
    }
}

