/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.agent.clients.service;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.status.monitor.agent.clients.common.ServiceLoginClient;
import org.wso2.carbon.status.monitor.agent.internal.core.MySQLConnector;
import org.wso2.carbon.status.monitor.core.StatusMonitorConfigurationBuilder;
import org.wso2.carbon.status.monitor.core.beans.AuthConfigBean;
import org.wso2.carbon.status.monitor.core.beans.SampleTenantConfigBean;
import org.wso2.carbon.status.monitor.core.jdbc.MySQLConnectionInitializer;

public class DataServerClient
extends Thread {
    private static final Log log = LogFactory.getLog(DataServerClient.class);
    private static final AuthConfigBean authConfigBean = StatusMonitorConfigurationBuilder.getAuthConfigBean();
    private static final SampleTenantConfigBean sampleTenantConfigBean = StatusMonitorConfigurationBuilder.getSampleTenantConfigBean();

    private static OMElement createPayLoad() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://ws.wso2.org/dataservice", "ns1");
        return fac.createOMElement("getCustomers", omNs);
    }

    public void run() {
        block6: while (true) {
            try {
                while (true) {
                    DataServerClient.executeService();
                    if (this.isInterrupted()) break block6;
                    try {
                        DataServerClient.sleep(900000L);
                        continue block6;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                log.error((Object)e);
                continue;
            }
            catch (SQLException e) {
                log.error((Object)e);
                continue;
            }
            catch (ParseException e) {
                log.error((Object)e);
                continue;
            }
            break;
        }
    }

    private static void executeService() throws IOException, SQLException, ParseException {
        int serviceID = MySQLConnectionInitializer.getServiceID((String)"StratosLive Data Services Server");
        OMElement payload = DataServerClient.createPayLoad();
        ServiceClient serviceclient = new ServiceClient();
        Options opts = new Options();
        opts.setTo(new EndpointReference("http://data.stratoslive.wso2.com/services/t/" + authConfigBean.getTenant() + "/GSpreadSample"));
        opts.setAction("http://ws.wso2.org/dataservice/getCustomers");
        if (ServiceLoginClient.loginChecker("data.stratoslive.wso2.com", serviceID)) {
            serviceclient.setOptions(opts);
            try {
                OMElement result = serviceclient.sendReceive(payload);
                if (log.isDebugEnabled()) {
                    log.debug((Object)result);
                }
                if (result.toString().indexOf("Signal Gift Stores") > 0) {
                    DataServerClient.executeShoppingCartDSPlatformSample();
                } else {
                    MySQLConnector.insertStats(serviceID, false);
                    MySQLConnector.insertState(serviceID, false, "Service Invocation failed");
                }
            }
            catch (AxisFault e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                String msg = "Error in executing service for DSS Server client";
                log.warn((Object)msg, (Throwable)e);
            }
            catch (NullPointerException e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                String msg = "NPE in executing the service for DSS client";
                log.warn((Object)msg, (Throwable)e);
            }
        }
    }

    private static boolean executeShoppingCartDSPlatformSample() throws IOException, SQLException, ParseException {
        Boolean sampleStatus = false;
        int serviceID = MySQLConnectionInitializer.getServiceID((String)"StratosLive Data Services Server");
        String payload = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">\n   <soapenv:Header/>\n   <soapenv:Body/>\n</soapenv:Envelope>";
        String action = "getAllCategories";
        try {
            OMElement result = DataServerClient.sendRequest(payload, action, new EndpointReference("http://data.stratoslive.wso2.com/services/t/" + sampleTenantConfigBean.getTenant() + "/ShoppingCartDS"));
            if (result.toString().indexOf("Compact Lens-Shutter Cameras") > 0) {
                sampleStatus = true;
                MySQLConnector.insertStats(serviceID, true);
                MySQLConnector.insertState(serviceID, true, "");
            } else {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, "Platform sample ShoppingCartDS invocation failed");
            }
        }
        catch (AxisFault e) {
            MySQLConnector.insertStats(serviceID, false);
            MySQLConnector.insertState(serviceID, false, "Platform sample ShoppingCartDS: " + e.getMessage());
            String msg = "Fault in executing the Shopping cart sample";
            log.warn((Object)msg, (Throwable)e);
        }
        catch (NullPointerException e) {
            MySQLConnector.insertStats(serviceID, false);
            MySQLConnector.insertState(serviceID, false, "Platform sample ShoppingCartDS: " + e.getMessage());
            String msg = "NPE in executing the shopping cart sample";
            log.warn((Object)msg, (Throwable)e);
        }
        catch (XMLStreamException e) {
            String msg = "XMLStreamException in executing the shopping cart sample";
            log.warn((Object)msg, (Throwable)e);
        }
        return sampleStatus;
    }

    private static OMElement sendRequest(String payloadStr, String action, EndpointReference targetEPR) throws XMLStreamException, AxisFault {
        OMElement payload = AXIOMUtil.stringToOM((String)payloadStr);
        Options options = new Options();
        options.setTo(targetEPR);
        options.setAction("urn:" + action);
        ServiceClient sender = new ServiceClient();
        sender.setOptions(options);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request: " + payload.toString()));
        }
        OMElement result = sender.sendReceive(payload);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Response: " + payload.toString()));
        }
        return result;
    }
}

