/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.agent.clients.service;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.status.monitor.agent.clients.common.ServiceLoginClient;
import org.wso2.carbon.status.monitor.agent.internal.core.MySQLConnector;
import org.wso2.carbon.status.monitor.core.StatusMonitorConfigurationBuilder;
import org.wso2.carbon.status.monitor.core.beans.AuthConfigBean;
import org.wso2.carbon.status.monitor.core.jdbc.MySQLConnectionInitializer;

public class BRSServerClient
extends Thread {
    private static final Log log = LogFactory.getLog(BRSServerClient.class);
    private static final AuthConfigBean authConfigBean = StatusMonitorConfigurationBuilder.getAuthConfigBean();

    public void run() {
        block6: while (true) {
            try {
                while (true) {
                    BRSServerClient.executeService();
                    if (this.isInterrupted()) break block6;
                    try {
                        BRSServerClient.sleep(900000L);
                        continue block6;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                log.error((Object)e);
                continue;
            }
            catch (SQLException e) {
                log.error((Object)e);
                continue;
            }
            catch (ParseException e) {
                log.error((Object)e);
                continue;
            }
            break;
        }
    }

    private static OMElement createPayLoad() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://brs.carbon.wso2.org", "ns1");
        OMNamespace nameNs = fac.createOMNamespace("http://greeting.samples/xsd", "ns2");
        OMElement method = fac.createOMElement("greetMe", omNs);
        OMElement value = fac.createOMElement("User", omNs);
        OMElement NameValue = fac.createOMElement("name", nameNs);
        NameValue.addChild((OMNode)fac.createOMText((OMContainer)NameValue, "QAuser"));
        value.addChild((OMNode)NameValue);
        method.addChild((OMNode)value);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Method in createPayload(): " + method.toString()));
        }
        return method;
    }

    private static void executeService() throws IOException, SQLException, ParseException {
        int serviceID = MySQLConnectionInitializer.getServiceID((String)"StratosLive Business Rules Server");
        OMElement payload = BRSServerClient.createPayLoad();
        ServiceClient serviceclient = new ServiceClient();
        Options opts = new Options();
        opts.setTo(new EndpointReference("http://rule.stratoslive.wso2.com/services/t/" + authConfigBean.getTenant() + "/GreetingService"));
        opts.setAction("http://brs.carbon.wso2.org/greetMe");
        if (ServiceLoginClient.loginChecker("rule.stratoslive.wso2.com", serviceID)) {
            serviceclient.setOptions(opts);
            try {
                OMElement result = serviceclient.sendReceive(payload);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Result in BRSServerClient: " + result.toString()));
                }
                if (result.toString().indexOf("QAuser") > 0) {
                    MySQLConnector.insertStats(serviceID, true);
                    MySQLConnector.insertState(serviceID, true, "");
                } else {
                    MySQLConnector.insertStats(serviceID, false);
                    MySQLConnector.insertState(serviceID, false, "Service Invocation failed");
                }
            }
            catch (AxisFault e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                String msg = "Fault when executing service: BRSServerClient: ";
                log.warn((Object)msg, (Throwable)e);
            }
            catch (NullPointerException e) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, e.getMessage());
                String msg = "NPE when executing service: BRSServerClient: ";
                log.warn((Object)msg, (Throwable)e);
            }
        }
    }
}

