/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.agent.clients.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import java.text.ParseException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.status.monitor.agent.clients.common.ServiceLoginClient;
import org.wso2.carbon.status.monitor.agent.internal.core.MySQLConnector;
import org.wso2.carbon.status.monitor.core.StatusMonitorConfigurationBuilder;
import org.wso2.carbon.status.monitor.core.beans.AuthConfigBean;
import org.wso2.carbon.status.monitor.core.jdbc.MySQLConnectionInitializer;

public class ApplicationServerClient
extends Thread {
    private static int serviceID;
    private static final Log log;
    private static final AuthConfigBean authConfigBean;

    private static OMElement createPayLoad() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://service.carbon.wso2.org", "ns1");
        OMElement method = fac.createOMElement("echoString", omNs);
        OMElement value = fac.createOMElement("s", omNs);
        value.addChild((OMNode)fac.createOMText((OMContainer)value, "Hello World"));
        method.addChild((OMNode)value);
        return method;
    }

    public void run() {
        block6: while (true) {
            try {
                while (true) {
                    ApplicationServerClient.executeService();
                    if (this.isInterrupted()) break block6;
                    try {
                        ApplicationServerClient.sleep(900000L);
                        continue block6;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                log.error((Object)e);
                continue;
            }
            catch (SQLException e) {
                log.error((Object)e);
                continue;
            }
            catch (ParseException e) {
                log.error((Object)e);
                continue;
            }
            break;
        }
    }

    private static void executeService() throws SQLException, ParseException, IOException {
        serviceID = MySQLConnectionInitializer.getServiceID((String)"StratosLive Application Server");
        OMElement payload = ApplicationServerClient.createPayLoad();
        ServiceClient serviceclient = new ServiceClient();
        Options opts = new Options();
        opts.setTo(new EndpointReference("http://appserver.stratoslive.wso2.com/services/t/" + authConfigBean.getTenant() + "/Axis2Service"));
        opts.setAction("http://service.carbon.wso2.orgechoString");
        opts.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
        if (ServiceLoginClient.loginChecker("appserver.stratoslive.wso2.com", serviceID)) {
            if (!ApplicationServerClient.webappTest()) {
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, "Webapp Invocation failed");
                log.warn((Object)"WebApp invocation failed");
            } else {
                serviceclient.setOptions(opts);
                try {
                    OMElement result = serviceclient.sendReceive(payload);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)result);
                    }
                    if (result.toString().indexOf("Hello World") > 0) {
                        if (ApplicationServerClient.pingPlatformTenant().booleanValue()) {
                            MySQLConnector.insertStats(serviceID, true);
                            MySQLConnector.insertState(serviceID, true, "");
                        }
                    } else {
                        MySQLConnector.insertStats(serviceID, false);
                        MySQLConnector.insertState(serviceID, false, " Service Invocation failed");
                        log.warn((Object)"Service Invocation Failed");
                    }
                }
                catch (AxisFault e) {
                    MySQLConnector.insertStats(serviceID, false);
                    MySQLConnector.insertState(serviceID, false, e.getMessage());
                    String msg = "Axis Fault in invoking the Appserver Client";
                    log.warn((Object)msg, (Throwable)e);
                }
                catch (NullPointerException e) {
                    MySQLConnector.insertStats(serviceID, false);
                    MySQLConnector.insertState(serviceID, false, e.getMessage());
                    String msg = "Null Pointer Exception in invoking the Appserver client";
                    log.warn((Object)msg, (Throwable)e);
                }
            }
        }
    }

    private static Boolean pingPlatformTenant() throws IOException, SQLException, ParseException {
        Boolean pingPlatformTenantStatus = false;
        OMElement payload = ApplicationServerClient.createPayLoad();
        ServiceClient serviceclient = new ServiceClient();
        Options opts = new Options();
        opts.setTo(new EndpointReference("http://appserver.stratoslive.wso2.com/services/t/" + StatusMonitorConfigurationBuilder.getSampleTenantConfigBean().getTenant() + "/Axis2Service/"));
        opts.setAction("http://service.carbon.wso2.org/echoString");
        opts.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
        serviceclient.setOptions(opts);
        try {
            OMElement result = serviceclient.sendReceive(payload);
            if (result.toString().indexOf("Hello World") > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Appserver test client - service invocation test passed");
                }
                pingPlatformTenantStatus = true;
            } else {
                String msg = "Ping to platform sample tenant domain failed";
                MySQLConnector.insertStats(serviceID, false);
                MySQLConnector.insertState(serviceID, false, msg);
                log.warn((Object)msg);
            }
        }
        catch (AxisFault e) {
            MySQLConnector.insertStats(serviceID, false);
            String msg = "Ping to platform sample tenant domain failed: ";
            MySQLConnector.insertState(serviceID, false, msg + e.getMessage());
            log.warn((Object)msg, (Throwable)e);
        }
        catch (NullPointerException e) {
            MySQLConnector.insertStats(serviceID, false);
            String msg = "Ping to platform sample tenant domain failed: ";
            MySQLConnector.insertState(serviceID, false, msg + e.getMessage());
            log.warn((Object)msg, (Throwable)e);
        }
        return pingPlatformTenantStatus;
    }

    private static boolean webappTest() {
        boolean webappStatus = false;
        try {
            String inputLine;
            URL webAppURL = new URL("http://appserver.stratoslive.wso2.com/t/" + authConfigBean.getTenant() + "/webapps/SimpleServlet/simple-servlet");
            URLConnection yc = webAppURL.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)inputLine);
                }
                if (inputLine.indexOf("Hello, World") <= 1) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("True : " + inputLine.indexOf("Hello, World")));
                }
                webappStatus = true;
            }
            in.close();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return webappStatus;
    }

    static {
        log = LogFactory.getLog(ApplicationServerClient.class);
        authConfigBean = StatusMonitorConfigurationBuilder.getAuthConfigBean();
    }
}

