/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.status.monitor.agent.clients.common;

import java.rmi.RemoteException;
import java.sql.SQLException;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.load.balance.agent.stub.LoadBalanceAgentServiceStub;
import org.wso2.carbon.status.monitor.agent.internal.core.MySQLConnector;

public class LoadBalanceAgentClient {
    private static final Log log = LogFactory.getLog(LoadBalanceAgentClient.class);
    private static final String serviceName = "LoadBalanceAgentService";
    private static final String services = "/services/";

    public static double getLoadAverageFromInstances(String hostName, int serviceID) throws SQLException {
        String serviceUrl;
        double loadAverage = -1.0;
        try {
            serviceUrl = "https://" + hostName + services + serviceName;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to get the running application instances to get the load average", (Throwable)e);
            }
            return loadAverage;
        }
        try {
            LoadBalanceAgentServiceStub stub = new LoadBalanceAgentServiceStub(serviceUrl);
            loadAverage = stub.getLoadAverage();
        }
        catch (AxisFault e) {
            MySQLConnector.insertStats(serviceID, false);
            MySQLConnector.insertState(serviceID, false, e.getMessage());
            String msg = "Invoking the Load Balance Agent Client Failed";
            log.warn((Object)msg, (Throwable)e);
        }
        catch (RemoteException e) {
            MySQLConnector.insertStats(serviceID, false);
            MySQLConnector.insertState(serviceID, false, e.getMessage());
            String msg = "Remote Exception in invoking the Load Balance Agent Client";
            log.warn((Object)msg, (Throwable)e);
        }
        catch (Exception e) {
            MySQLConnector.insertStats(serviceID, false);
            MySQLConnector.insertState(serviceID, false, e.getMessage());
            String msg = "Exception in invoking the Load Balance Agent Client";
            log.warn((Object)msg, (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Load Average from the service: " + serviceUrl + ": " + loadAverage));
        }
        return loadAverage;
    }
}

