/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics.ui;

import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.statistics.stub.StatisticsAdminStub;
import org.wso2.carbon.statistics.stub.types.carbon.OperationStatistics;
import org.wso2.carbon.statistics.stub.types.carbon.ServiceStatistics;
import org.wso2.carbon.statistics.stub.types.carbon.SystemStatistics;

public class StatisticsAdminClient {
    private static final Log log = LogFactory.getLog(StatisticsAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.statistics.ui.i18n.Resources";
    private StatisticsAdminStub stub;
    private ResourceBundle bundle;

    public StatisticsAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "StatisticsAdmin";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new StatisticsAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public SystemStatistics getSystemStatistics() throws RemoteException {
        try {
            return this.stub.getSystemStatistics();
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.system.stats"), e);
            return null;
        }
    }

    public ServiceStatistics getServiceStatistics(String serviceName) throws RemoteException {
        try {
            return this.stub.getServiceStatistics(serviceName);
        }
        catch (RemoteException e) {
            this.handleException(MessageFormat.format(this.bundle.getString("cannot.get.service.stats"), serviceName), e);
            return null;
        }
    }

    public OperationStatistics getOperationStatistics(String serviceName, String operationName) throws RemoteException {
        try {
            return this.stub.getOperationStatistics(serviceName, operationName);
        }
        catch (RemoteException e) {
            this.handleException(MessageFormat.format(this.bundle.getString("cannot.get.operation.stats"), serviceName, operationName), e);
            return null;
        }
    }

    private void handleException(String msg, Exception e) throws RemoteException {
        log.error((Object)msg, (Throwable)e);
        throw new RemoteException(msg, e);
    }
}

