/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics.transport.ui;

import java.rmi.RemoteException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.statistics.transport.stub.TransportStatisticsAdminStub;
import org.wso2.carbon.statistics.transport.stub.types.carbon.SystemTransportStatistics;
import org.wso2.carbon.statistics.transport.stub.types.carbon.ThreadViewStatistics;
import org.wso2.carbon.statistics.transport.stub.types.carbon.TransportStatistics;

public class TransportStatisticsAdminClient {
    private static final Log log = LogFactory.getLog(TransportStatisticsAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.statistics.transport.ui.i18n.Resources";
    private TransportStatisticsAdminStub stub;
    private ResourceBundle bundle;

    public TransportStatisticsAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "TransportStatisticsAdmin";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new TransportStatisticsAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public String[] getExposedTransports() throws RemoteException {
        try {
            return this.stub.getExposedTransports();
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getExposedTransports"), e);
            return null;
        }
    }

    public SystemTransportStatistics getSystemTransportStatistics() throws RemoteException {
        try {
            return this.stub.getAllTransportStatistics();
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getSystemTransportStatistics"), e);
            return null;
        }
    }

    public TransportStatistics getTransportStatistics(String transportName) throws RemoteException {
        try {
            return this.stub.getTransportStatistic(transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getTransportStatistics"), e);
            return null;
        }
    }

    public ThreadViewStatistics getThreadViewStatistics() throws RemoteException {
        try {
            return this.stub.getThreadViewStatistics();
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("Can not get Thread View Statistics"), e);
            return null;
        }
    }

    public String getTransportClassName(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getTransportClassName(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getTransportClassName"), e);
            return null;
        }
    }

    public int getActiveThreadCount(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getActiveThreadCount(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getActiveThreadCount"), e);
            return 0;
        }
    }

    public double getAvgSizeReceived(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getAvgSizeReceived(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getAvgSizeReceived"), e);
            return 0.0;
        }
    }

    public double getAvgSizeSent(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getAvgSizeSent(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getAvgSizeSent"), e);
            return 0.0;
        }
    }

    public long getBytesReceived(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getBytesReceived(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getBytesReceived"), e);
            return 0L;
        }
    }

    public long getBytesSent(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getBytesSent(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getBytesSent"), e);
            return 0L;
        }
    }

    public long getFaultsReceiving(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getFaultsReceiving(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getFaultsReceiving"), e);
            return 0L;
        }
    }

    public long getFaultsSending(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getFaultsSending(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getFaultsSending"), e);
            return 0L;
        }
    }

    public long getLastResetTime(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getLastResetTime(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getLastResetTime"), e);
            return 0L;
        }
    }

    public long getMaxSizeReceived(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getMaxSizeReceived(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getMaxSizeReceived"), e);
            return 0L;
        }
    }

    public long getMaxSizeSent(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getMaxSizeSent(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getMaxSizeSent"), e);
            return 0L;
        }
    }

    public long getMessagesReceived(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getMessagesReceived(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getMessagesReceived"), e);
            return 0L;
        }
    }

    public long getMessagesSent(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getMessagesSent(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getMessagesSent"), e);
            return 0L;
        }
    }

    public long getMetricsWindow(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getMetricsWindow(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getMetricsWindow"), e);
            return 0L;
        }
    }

    public long getMinSizeReceived(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getMinSizeReceived(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getMinSizeReceived"), e);
            return 0L;
        }
    }

    public long getMinSizeSent(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getMinSizeSent(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getMinSizeSent"), e);
            return 0L;
        }
    }

    public int getQueueSize(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getQueueSize(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getQueueSize"), e);
            return 0;
        }
    }

    public long getTimeoutsReceiving(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getTimeoutsReceiving(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getTimeoutsReceiving"), e);
            return 0L;
        }
    }

    public long getTimeoutsSending(String transportType, String transportName) throws RemoteException {
        try {
            return this.stub.getTimeoutsSending(transportType, transportName);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.transport.stats-getTimeoutsSending"), e);
            return 0L;
        }
    }

    private void handleException(String msg, Exception e) throws RemoteException {
        log.error((Object)msg, (Throwable)e);
        throw new RemoteException(msg, e);
    }
}

