/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics.transport.services.util;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportSender;

public class ConfigHolder {
    private static ConfigHolder configHolderSingleton = new ConfigHolder();
    private ConfigurationContext configContext = null;

    private ConfigHolder() {
    }

    public static ConfigHolder getInstance() {
        return configHolderSingleton;
    }

    public void setConfigurationContext(ConfigurationContext configContext) {
        this.configContext = configContext;
    }

    public String[] getAllTransports() {
        HashMap map = this.configContext.getAxisConfiguration().getTransportsIn();
        Iterator iterator = map.keySet().iterator();
        String[] array = new String[map.size()];
        int count = 0;
        while (iterator.hasNext()) {
            String key;
            array[count] = key = iterator.next().toString();
            ++count;
        }
        return array;
    }

    public TransportListener getHttpTransportListener() {
        return this.configContext.getAxisConfiguration().getTransportIn("http").getReceiver();
    }

    public TransportListener getTransportListener(String transportName) {
        return this.configContext.getAxisConfiguration().getTransportIn(transportName).getReceiver();
    }

    public TransportSender getTransportSender(String transportName) {
        return this.configContext.getAxisConfiguration().getTransportOut(transportName).getSender();
    }

    public String getTransportListenerClassName(String transportName) {
        return this.configContext.getAxisConfiguration().getTransportIn(transportName).getReceiver().getClass().getName();
    }

    public String getTransportSenderClassName(String transportName) {
        return this.configContext.getAxisConfiguration().getTransportOut(transportName).getSender().getClass().getName();
    }
}

