/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics.transport.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.statistics.transport.services.TransportStatisticsAdmin;
import org.wso2.carbon.statistics.transport.services.util.ConfigHolder;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.MBeanRegistrar;

public class TransportStatisticsServiceComponent {
    private static final Log log = LogFactory.getLog(TransportStatisticsServiceComponent.class);
    private ConfigurationContext configContext;
    private ServerConfigurationService serverConfiguration;
    private ServiceRegistration transportStatAdminServiceRegistration;

    protected void activate(ComponentContext ctxt) {
        try {
            this.transportStatAdminServiceRegistration = ctxt.getBundleContext().registerService(TransportStatisticsAdmin.class.getName(), (Object)new TransportStatisticsAdmin(), null);
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Transport Statistics bundle", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        this.transportStatAdminServiceRegistration.unregister();
        log.debug((Object)"Transport Statistics bundle is deactivated");
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        this.configContext = contextService.getServerConfigContext();
        ConfigHolder.getInstance().setConfigurationContext(this.configContext);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        AxisConfiguration axisConf = this.configContext.getAxisConfiguration();
        this.configContext = null;
    }

    private void registerMBeans(ServerConfigurationService serverConfigurationService) {
        if (this.serverConfiguration.getFirstProperty("Ports.Transport") != null) {
            MBeanRegistrar.registerMBean((Object)((Object)new TransportStatisticsAdmin()));
        }
    }

    protected void setServerConfiguration(ServerConfigurationService serverConfigurationService) {
        this.serverConfiguration = serverConfigurationService;
    }

    protected void unsetServerConfiguration(ServerConfigurationService serverConfigurationService) {
        this.serverConfiguration = null;
    }

    public ConfigurationContext getConfigurationConetxt() {
        return this.configContext;
    }
}

