/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics.transport.services.util;

import java.util.Hashtable;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadViewStatistics {
    private static final Log log = LogFactory.getLog(ThreadViewStatistics.class);
    private double clientWorkerAvgBlockedWorkerPercentage = 0.0;
    private double clientWorkerAvgUnblockedWorkerPercentage = 0.0;
    private int clientWorkerDeadLockedWorkers = 0;
    private double clientWorkerLast15MinuteBlockedWorkerPercentage = 0.0;
    private double clientWorkerLast24HourBlockedWorkerPercentage = 0.0;
    private double clientWorkerLast5MinuteBlockedWorkerPercentage = 0.0;
    private double clientWorkerLast8HourBlockedWorkerPercentage = 0.0;
    private double clientWorkerLastHourBlockedWorkerPercentage = 0.0;
    private double clientWorkerLastMinuteBlockedWorkerPercentage = 0.0;
    private String clientWorkerLastResetTime = "";
    private int clientWorkerTotalWorkerCount = 0;
    private double serverWorkerAvgBlockedWorkerPercentage = 0.0;
    private double serverWorkerAvgUnblockedWorkerPercentage = 0.0;
    private int serverWorkerDeadLockedWorkers = 0;
    private double serverWorkerLast15MinuteBlockedWorkerPercentage = 0.0;
    private double serverWorkerLast24HourBlockedWorkerPercentage = 0.0;
    private double serverWorkerLast5MinuteBlockedWorkerPercentage = 0.0;
    private double serverWorkerLast8HourBlockedWorkerPercentage = 0.0;
    private double serverWorkerLastHourBlockedWorkerPercentage = 0.0;
    private double serverWorkerLastMinuteBlockedWorkerPercentage = 0.0;
    private String serverWorkerLastResetTime = "";
    private int serverWorkerTotalWorkerCount = 0;

    public ThreadViewStatistics(MBeanServer server) {
        String[] domains = server.getDomains();
        for (int i = 0; i < domains.length; ++i) {
            System.out.println("Domain[" + i + "] = " + domains[i]);
        }
        this.updateClientWorkerStats(server);
        this.updateServerWorkerStats(server);
    }

    private void updateClientWorkerStats(MBeanServer server) {
        ObjectName clientWorkerObjectName = null;
        try {
            clientWorkerObjectName = new ObjectName("org.apache.synapse:Type=Threading,Name=HttpClientWorker");
        }
        catch (MalformedObjectNameException e) {
            log.warn((Object)"Malformed Object Name for MBean", (Throwable)e);
        }
        String[] clientWorkerAttributes = new String[]{"avgBlockedWorkerPercentage", "avgUnblockedWorkerPercentage", "deadLockedWorkers", "last15MinuteBlockedWorkerPercentage", "last24HourBlockedWorkerPercentage", "last5MinuteBlockedWorkerPercentage", "last8HourBlockedWorkerPercentage", "lastHourBlockedWorkerPercentage", "lastMinuteBlockedWorkerPercentage", "lastResetTime,totalWorkerCount"};
        AttributeList list = null;
        try {
            list = server.getAttributes(clientWorkerObjectName, clientWorkerAttributes);
        }
        catch (InstanceNotFoundException e) {
            log.warn((Object)"Could not retrieve attributes for MBean", (Throwable)e);
        }
        catch (ReflectionException e) {
            log.warn((Object)"Could not retrieve attributes for MBean", (Throwable)e);
        }
        Hashtable<String, String> ht = new Hashtable<String, String>();
        if (list != null && list.size() > 0) {
            for (Object obj : list) {
                String[] keyValueArray = obj.toString().split("=");
                System.out.println(keyValueArray[0] + " = " + keyValueArray[1]);
                ht.put(keyValueArray[0], keyValueArray[1]);
            }
            this.setClientWorkerAvgBlockedWorkerPercentage(Double.parseDouble((String)ht.get("avgBlockedWorkerPercentage")));
            this.setClientWorkerAvgUnblockedWorkerPercentage(Double.parseDouble((String)ht.get("avgUnblockedWorkerPercentage")));
            this.setClientWorkerDeadLockedWorkers(Integer.parseInt((String)ht.get("deadLockedWorkers")));
            this.setClientWorkerLast15MinuteBlockedWorkerPercentage(Double.parseDouble((String)ht.get("last15MinuteBlockedWorkerPercentage")));
            this.setClientWorkerLast24HourBlockedWorkerPercentage(Double.parseDouble((String)ht.get("last24HourBlockedWorkerPercentage")));
            this.setClientWorkerLast5MinuteBlockedWorkerPercentage(Double.parseDouble((String)ht.get("last5MinuteBlockedWorkerPercentage")));
            this.setClientWorkerLast8HourBlockedWorkerPercentage(Double.parseDouble((String)ht.get("last8HourBlockedWorkerPercentage")));
            this.setClientWorkerLastHourBlockedWorkerPercentage(Double.parseDouble((String)ht.get("lastHourBlockedWorkerPercentage")));
            this.setClientWorkerLastMinuteBlockedWorkerPercentage(Double.parseDouble((String)ht.get("lastMinuteBlockedWorkerPercentage")));
            this.setClientWorkerLastResetTime((String)ht.get("lastResetTime"));
            this.setClientWorkerTotalWorkerCount(Integer.parseInt((String)ht.get("totalWorkerCount")));
        }
    }

    private void updateServerWorkerStats(MBeanServer server) {
        ObjectName serverWorkerObjectName = null;
        try {
            serverWorkerObjectName = new ObjectName("org.apache.synapse:Type=Threading,Name=HttpServerWorker");
        }
        catch (MalformedObjectNameException e) {
            log.warn((Object)"Malformed Object Name for MBean", (Throwable)e);
        }
        String[] serverWorkerAttributes = new String[]{"avgBlockedWorkerPercentage", "avgUnblockedWorkerPercentage", "deadLockedWorkers", "last15MinuteBlockedWorkerPercentage", "last24HourBlockedWorkerPercentage", "last5MinuteBlockedWorkerPercentage", "last8HourBlockedWorkerPercentage", "lastHourBlockedWorkerPercentage", "lastMinuteBlockedWorkerPercentage", "lastResetTime,totalWorkerCount"};
        AttributeList list = null;
        try {
            list = server.getAttributes(serverWorkerObjectName, serverWorkerAttributes);
        }
        catch (InstanceNotFoundException e) {
            log.warn((Object)"Could not retrieve attributes for MBean", (Throwable)e);
        }
        catch (ReflectionException e) {
            log.warn((Object)"Could not retrieve attributes for MBean", (Throwable)e);
        }
        Hashtable<String, String> ht = new Hashtable<String, String>();
        if (list != null && list.size() > 0) {
            for (Object obj : list) {
                String[] keyValueArray = obj.toString().split("=");
                ht.put(keyValueArray[0], keyValueArray[1]);
            }
            this.setServerWorkerAvgBlockedWorkerPercentage(Double.parseDouble((String)ht.get("avgBlockedWorkerPercentage")));
            this.setServerWorkerAvgUnblockedWorkerPercentage(Double.parseDouble((String)ht.get("avgUnblockedWorkerPercentage")));
            this.setServerWorkerDeadLockedWorkers(Integer.parseInt((String)ht.get("deadLockedWorkers")));
            this.setServerWorkerLast15MinuteBlockedWorkerPercentage(Double.parseDouble((String)ht.get("last15MinuteBlockedWorkerPercentage")));
            this.setServerWorkerLast24HourBlockedWorkerPercentage(Double.parseDouble((String)ht.get("last24HourBlockedWorkerPercentage")));
            this.setServerWorkerLast5MinuteBlockedWorkerPercentage(Double.parseDouble((String)ht.get("last5MinuteBlockedWorkerPercentage")));
            this.setServerWorkerLast8HourBlockedWorkerPercentage(Double.parseDouble((String)ht.get("last8HourBlockedWorkerPercentage")));
            this.setServerWorkerLastHourBlockedWorkerPercentage(Double.parseDouble((String)ht.get("lastHourBlockedWorkerPercentage")));
            this.setServerWorkerLastMinuteBlockedWorkerPercentage(Double.parseDouble((String)ht.get("lastMinuteBlockedWorkerPercentage")));
            this.setServerWorkerLastResetTime((String)ht.get("lastResetTime"));
            this.setServerWorkerTotalWorkerCount(Integer.parseInt((String)ht.get("totalWorkerCount")));
        }
    }

    public double getClientWorkerAvgBlockedWorkerPercentage() {
        return this.clientWorkerAvgBlockedWorkerPercentage;
    }

    public void setClientWorkerAvgBlockedWorkerPercentage(double clientWorkerAvgBlockedWorkerPercentage) {
        this.clientWorkerAvgBlockedWorkerPercentage = clientWorkerAvgBlockedWorkerPercentage;
    }

    public double getClientWorkerAvgUnblockedWorkerPercentage() {
        return this.clientWorkerAvgUnblockedWorkerPercentage;
    }

    public void setClientWorkerAvgUnblockedWorkerPercentage(double clientWorkerAvgUnblockedWorkerPercentage) {
        this.clientWorkerAvgUnblockedWorkerPercentage = clientWorkerAvgUnblockedWorkerPercentage;
    }

    public int getClientWorkerDeadLockedWorkers() {
        return this.clientWorkerDeadLockedWorkers;
    }

    public void setClientWorkerDeadLockedWorkers(int clientWorkerDeadLockedWorkers) {
        this.clientWorkerDeadLockedWorkers = clientWorkerDeadLockedWorkers;
    }

    public double getClientWorkerLast15MinuteBlockedWorkerPercentage() {
        return this.clientWorkerLast15MinuteBlockedWorkerPercentage;
    }

    public void setClientWorkerLast15MinuteBlockedWorkerPercentage(double clientWorkerLast15MinuteBlockedWorkerPercentage) {
        this.clientWorkerLast15MinuteBlockedWorkerPercentage = clientWorkerLast15MinuteBlockedWorkerPercentage;
    }

    public double getClientWorkerLast24HourBlockedWorkerPercentage() {
        return this.clientWorkerLast24HourBlockedWorkerPercentage;
    }

    public void setClientWorkerLast24HourBlockedWorkerPercentage(double clientWorkerLast24HourBlockedWorkerPercentage) {
        this.clientWorkerLast24HourBlockedWorkerPercentage = clientWorkerLast24HourBlockedWorkerPercentage;
    }

    public double getClientWorkerLast5MinuteBlockedWorkerPercentage() {
        return this.clientWorkerLast5MinuteBlockedWorkerPercentage;
    }

    public void setClientWorkerLast5MinuteBlockedWorkerPercentage(double clientWorkerLast5MinuteBlockedWorkerPercentage) {
        this.clientWorkerLast5MinuteBlockedWorkerPercentage = clientWorkerLast5MinuteBlockedWorkerPercentage;
    }

    public double getClientWorkerLast8HourBlockedWorkerPercentage() {
        return this.clientWorkerLast8HourBlockedWorkerPercentage;
    }

    public void setClientWorkerLast8HourBlockedWorkerPercentage(double clientWorkerLast8HourBlockedWorkerPercentage) {
        this.clientWorkerLast8HourBlockedWorkerPercentage = clientWorkerLast8HourBlockedWorkerPercentage;
    }

    public double getClientWorkerLastHourBlockedWorkerPercentage() {
        return this.clientWorkerLastHourBlockedWorkerPercentage;
    }

    public void setClientWorkerLastHourBlockedWorkerPercentage(double clientWorkerLastHourBlockedWorkerPercentage) {
        this.clientWorkerLastHourBlockedWorkerPercentage = clientWorkerLastHourBlockedWorkerPercentage;
    }

    public double getClientWorkerLastMinuteBlockedWorkerPercentage() {
        return this.clientWorkerLastMinuteBlockedWorkerPercentage;
    }

    public void setClientWorkerLastMinuteBlockedWorkerPercentage(double clientWorkerLastMinuteBlockedWorkerPercentage) {
        this.clientWorkerLastMinuteBlockedWorkerPercentage = clientWorkerLastMinuteBlockedWorkerPercentage;
    }

    public String getClientWorkerLastResetTime() {
        return this.clientWorkerLastResetTime;
    }

    public void setClientWorkerLastResetTime(String clientWorkerLastResetTime) {
        this.clientWorkerLastResetTime = clientWorkerLastResetTime;
    }

    public int getClientWorkerTotalWorkerCount() {
        return this.clientWorkerTotalWorkerCount;
    }

    public void setClientWorkerTotalWorkerCount(int clientWorkerTotalWorkerCount) {
        this.clientWorkerTotalWorkerCount = clientWorkerTotalWorkerCount;
    }

    public double getServerWorkerAvgBlockedWorkerPercentage() {
        return this.serverWorkerAvgBlockedWorkerPercentage;
    }

    public void setServerWorkerAvgBlockedWorkerPercentage(double serverWorkerAvgBlockedWorkerPercentage) {
        this.serverWorkerAvgBlockedWorkerPercentage = serverWorkerAvgBlockedWorkerPercentage;
    }

    public double getServerWorkerAvgUnblockedWorkerPercentage() {
        return this.serverWorkerAvgUnblockedWorkerPercentage;
    }

    public void setServerWorkerAvgUnblockedWorkerPercentage(double serverWorkerAvgUnblockedWorkerPercentage) {
        this.serverWorkerAvgUnblockedWorkerPercentage = serverWorkerAvgUnblockedWorkerPercentage;
    }

    public int getServerWorkerDeadLockedWorkers() {
        return this.serverWorkerDeadLockedWorkers;
    }

    public void setServerWorkerDeadLockedWorkers(int serverWorkerDeadLockedWorkers) {
        this.serverWorkerDeadLockedWorkers = serverWorkerDeadLockedWorkers;
    }

    public double getServerWorkerLast15MinuteBlockedWorkerPercentage() {
        return this.serverWorkerLast15MinuteBlockedWorkerPercentage;
    }

    public void setServerWorkerLast15MinuteBlockedWorkerPercentage(double serverWorkerLast15MinuteBlockedWorkerPercentage) {
        this.serverWorkerLast15MinuteBlockedWorkerPercentage = serverWorkerLast15MinuteBlockedWorkerPercentage;
    }

    public double getServerWorkerLast24HourBlockedWorkerPercentage() {
        return this.serverWorkerLast24HourBlockedWorkerPercentage;
    }

    public void setServerWorkerLast24HourBlockedWorkerPercentage(double serverWorkerLast24HourBlockedWorkerPercentage) {
        this.serverWorkerLast24HourBlockedWorkerPercentage = serverWorkerLast24HourBlockedWorkerPercentage;
    }

    public double getServerWorkerLast5MinuteBlockedWorkerPercentage() {
        return this.serverWorkerLast5MinuteBlockedWorkerPercentage;
    }

    public void setServerWorkerLast5MinuteBlockedWorkerPercentage(double serverWorkerLast5MinuteBlockedWorkerPercentage) {
        this.serverWorkerLast5MinuteBlockedWorkerPercentage = serverWorkerLast5MinuteBlockedWorkerPercentage;
    }

    public double getServerWorkerLast8HourBlockedWorkerPercentage() {
        return this.serverWorkerLast8HourBlockedWorkerPercentage;
    }

    public void setServerWorkerLast8HourBlockedWorkerPercentage(double serverWorkerLast8HourBlockedWorkerPercentage) {
        this.serverWorkerLast8HourBlockedWorkerPercentage = serverWorkerLast8HourBlockedWorkerPercentage;
    }

    public double getServerWorkerLastHourBlockedWorkerPercentage() {
        return this.serverWorkerLastHourBlockedWorkerPercentage;
    }

    public void setServerWorkerLastHourBlockedWorkerPercentage(double serverWorkerLastHourBlockedWorkerPercentage) {
        this.serverWorkerLastHourBlockedWorkerPercentage = serverWorkerLastHourBlockedWorkerPercentage;
    }

    public double getServerWorkerLastMinuteBlockedWorkerPercentage() {
        return this.serverWorkerLastMinuteBlockedWorkerPercentage;
    }

    public void setServerWorkerLastMinuteBlockedWorkerPercentage(double serverWorkerLastMinuteBlockedWorkerPercentage) {
        this.serverWorkerLastMinuteBlockedWorkerPercentage = serverWorkerLastMinuteBlockedWorkerPercentage;
    }

    public String getServerWorkerLastResetTime() {
        return this.serverWorkerLastResetTime;
    }

    public void setServerWorkerLastResetTime(String serverWorkerLastResetTime) {
        this.serverWorkerLastResetTime = serverWorkerLastResetTime;
    }

    public int getServerWorkerTotalWorkerCount() {
        return this.serverWorkerTotalWorkerCount;
    }

    public void setServerWorkerTotalWorkerCount(int serverWorkerTotalWorkerCount) {
        this.serverWorkerTotalWorkerCount = serverWorkerTotalWorkerCount;
    }
}

